<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/material_extra.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['id_producto']) ||
    !isset($_POST['nombre']) 
) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

// 1. Verificar si existe el documento_pdf y si no retornar un error
if (!isset($_FILES['documento_pdf']['name'])) {
    $response['response'] = 'error';
    $response['message'] = 'No hay documento_pdf';
    echo json_encode($response);
    return;
}

// 2. Si existe, hay que moverlo a nuestra ruta y lo damos de alta a la BD
$id_producto = $_POST['id_producto'];
$pdf_material_extra = $_FILES['documento_pdf']['name'];

$extension = pathinfo($pdf_material_extra, PATHINFO_EXTENSION);
$nombre_pdf = uniqid() . "-" . $id_producto . '.' . $extension;
$pdf_material_extra_ruta = '../../assets/pdf/material_extra/' . $nombre_pdf;

if (!move_uploaded_file($_FILES['documento_pdf']['tmp_name'], $pdf_material_extra_ruta)) {
    $response['response'] = 'error';
    $response['message'] = 'No se pudo subir el pdf de material extra';
    echo json_encode($response);
    return;
}
// 2.1 Obtenemos la ruta final
$ruta_final_pdf = "assets/pdf/material_extra/" . $nombre_pdf;

// 3. Insertamos el material extra
$nombre = $_POST['nombre'];
$descripcion = ($_POST['descripcion'] !== "") ? $_POST['descripcion'] : NULL;

$material_extra = MaterialExtra::mdlAddMaterialExtra($id_producto, $ruta_final_pdf, $nombre, $descripcion);

if (!$material_extra) {
    $response['response'] = 'error';
    $response['message'] = 'No se agregó el material extra';

    // Borramos el pdf que se subió
    unlink($pdf_material_extra_ruta);

    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('add', 'material_extra', $material_extra, $id_usuario, NULL);

$response['response'] = 'success';
$response['data'] = $material_extra;

echo json_encode($response);