<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/formulario_contacto.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['nombre']) ||
    !isset($_POST['correo']) ||
    !isset($_POST['telefono']) ||
    !isset($_POST['mensaje'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_formulario_contacto = $_POST['id_formulario_contacto'];

$id_usuario = (!isset($_POST['id_usuario'])) ? NULL : DecodeUser::handlePostUsuario($_POST['id_usuario']);
$id_producto = (!isset($_POST['id_producto'])) ? NULL : $_POST['id_producto'];
$visto = (!isset($_POST['visto'])) ? "0" : $_POST['visto'];

$nombre = $_POST['nombre'];
$correo = $_POST['correo'];
$telefono = $_POST['telefono'];
$mensaje = $_POST['mensaje'];

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('formulario_contacto', $id_formulario_contacto));

$formulario_contacto = FormularioContacto::mdlUpdateFormularioContacto($id_formulario_contacto, $id_usuario, $id_producto, $nombre, $correo, $telefono, $mensaje, $visto);

if (!$formulario_contacto) {
    $response['response'] = 'error';
    $response['data'] = 'No se actualizó el formulario de contacto';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'formulario_contacto', $id_formulario_contacto, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = $formulario_contacto;

echo json_encode($response);