<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/estado_reclamo.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['nombre']) ||
    !isset($_POST['descripcion'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$nombre = $_POST['nombre'];
$descripcion = $_POST['descripcion'];

$estado_reclamo = EstadoReclamo::mdlAddEstadoReclamo($nombre, $descripcion);

if (!$estado_reclamo) {
    $response['response'] = 'error';
    $response['data'] = 'No se agregó el estado de reclamo';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('create', 'estado_reclamo', $estado_reclamo, $id_usuario, NULL);

$response['response'] = 'success';
$response['data'] = $estado_reclamo;

echo json_encode($response);
