<?php

error_reporting(E_ALL);
error_reporting(-1);
ini_set('error_reporting', E_ALL);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require_once '../../modelo/peso_envio.php';
require '../../modelo/cercania_almacen_odoo_cp.php';
require '../../modelo/pak2go.php';

class CostosPaqueteria
{
    public static function costoEnvioCarrito($pesos)
    {
        $total = 0;

        foreach ($pesos as $peso) {
            $calculo = ModeloPesoEnvio::mdlGetCostosEnvio($peso);
            $total += $calculo['costo_express'];
        }
        return $total;
    }

    public static function costosEnvio($pesos)
    {
        $paqueteria = array();
        $aux_dhl = 0;
        $aux_express = 0;
        foreach ($pesos as $key => $peso) {
            $calculo = ModeloPesoEnvio::mdlGetCostosEnvio($peso);
            if ($calculo['costo_dhl_odoo'] == null)
                $aux_dhl++;

            if ($calculo['costo_express_odoo'] == null)
                $aux_express++;

            $paqueteria[0]['dhl'] += $calculo['costo_dhl'];
            $paqueteria[1]['express'] += $calculo['costo_express'];
        }
        if ($aux_dhl > 0)
            $paqueteria[0]['dhl'] = [];
        if ($aux_express > 0)
            $paqueteria[1]['express'] = [];

        return $paqueteria;
    }

    // public static function costoPak2Go($control_envio, $cp_destino)
    // {
    //     $paqueterias = [];

    //     foreach ($control_envio as $envio) {

    //         $id_odoo = $envio['almacen'];
    //         $cp_origen = CercaniaAlmacenOdooCP::mdlGetUbicacionAlmacenCP($id_odoo);

    //         $colonia = DireccionesSEPOMEX::mdlGetDireccionSEPOMEXByCP($cp_destino);

    //         $type_of = 'box';

    //         // $peso_volumetrico = ($envio['dimensiones']['largo'] * $envio['dimensiones']['ancho'] * $envio['dimensiones']['alto']) / 5000;

    //         // if($peso_volumetrico > $envio['peso']){

    //         // }

    //         if ($envio['peso'] > 60) {
    //             $type_of = 'tarima';
    //         }


    //         $requestData = array(
    //             "zip_from" => $cp_origen['cp'],
    //             "zip_to" => $cp_destino,
    //             "to_neighbornhood" => $colonia[0]['d_mnpio'],
    //             "parcel" => array(
    //                 "weight" => ($envio['dimensiones']['peso'] < 1) ? 1 : $envio['dimensiones']['peso'],
    //                 "length" => $envio['dimensiones']['largo'],
    //                 "width" => $envio['dimensiones']['ancho'],
    //                 "height" => $envio['dimensiones']['alto'],
    //                 "type_of" => $type_of
    //             )
    //         );

    //         $response = Pak2Go::checkPrices($requestData);
    //         echo json_encode('-----------');
    //         echo json_encode($requestData);
    //         echo json_encode('-----------');
    //         echo json_encode($response);
    //         echo json_encode('-----------');
    //         foreach ($response as $paqueteria) {

    //             $nombre_paqueteria = $paqueteria['provider'];

    //             if ($nombre_paqueteria == 'DHL') {
    //                 $tipo_servicio = explode('_', $paqueteria['service_level_code']);
    //                 if ($tipo_servicio[0] == 'EXPRESS') {
    //                     $nombre_paqueteria = 'DHL EXPRESS';
    //                 }
    //             }

    //             if (!isset($paqueterias[$nombre_paqueteria])) {
    //                 $paqueterias[$nombre_paqueteria] = array(
    //                     'amount_local' => 0,
    //                     'currency_local' => $paqueteria['currency_local'],
    //                     'provider' => $nombre_paqueteria,
    //                     'service_level_name' => '',
    //                     'service_level_code' => '',
    //                     'days' => 0,
    //                     'insurable' => false,
    //                     'out_of_area_service' => false,
    //                     'out_of_area_pricing' => 0,
    //                     'total_pricing' => 0
    //                 );
    //             }

    //             $paqueterias[$nombre_paqueteria]['amount_local'] += round($paqueteria['amount_local'], 2);
    //             $paqueterias[$nombre_paqueteria]['service_level_name'] = $paqueteria['service_level_name'];
    //             $paqueterias[$nombre_paqueteria]['service_level_code'] = $paqueteria['service_level_code'];
    //             $paqueterias[$nombre_paqueteria]['days'] = $paqueteria['days'];
    //             $paqueterias[$nombre_paqueteria]['insurable'] = $paqueteria['insurable'];
    //             $paqueterias[$nombre_paqueteria]['out_of_area_service'] = $paqueteria['out_of_area_service'];
    //             $paqueterias[$nombre_paqueteria]['out_of_area_pricing'] += $paqueteria['out_of_area_pricing'];
    //             $paqueterias[$nombre_paqueteria]['total_pricing'] += round($paqueteria['total_pricing'], 2);
    //         }
    //     }

    //     return $paqueterias;
    // }

    public static function costoPak2Go($control_envio, $cp_destino)
    {
        $paqueterias = [];

        foreach ($control_envio as $envio) {

            $id_odoo = $envio['almacen'];
            $cp_origen = CercaniaAlmacenOdooCP::mdlGetUbicacionAlmacenCP($id_odoo);

            $colonia = DireccionesSEPOMEX::mdlGetDireccionSEPOMEXByCP($cp_destino);

            $type_of = 'box';

            if ($envio['dimensiones']['peso'] > 60) {
                $type_of = 'tarima';
            }

            $caja_envio = ModeloPesoEnvio::mdlGetCostosEnvio($envio['dimensiones']['peso']);

            $requestData = array(
                "zip_from" => $cp_origen['cp'],
                "zip_to" => $cp_destino,
                "to_neighbornhood" => $colonia[0]['d_mnpio'],
                "parcel" => array(
                    "weight" => ($envio['dimensiones']['peso'] < 1) ? 1 : $envio['dimensiones']['peso'],
                    "length" => $caja_envio['largo'],
                    "width" => $caja_envio['ancho'],
                    "height" => $caja_envio['alto'],
                    "type_of" => $type_of
                )
            );

            $response = Pak2Go::checkPrices($requestData);
            
            foreach ($response as $paqueteria) {

                $nombre_paqueteria = $paqueteria['provider'];

                if ($nombre_paqueteria == 'DHL') {
                    $tipo_servicio = explode('_', $paqueteria['service_level_code']);
                    if ($tipo_servicio[0] == 'EXPRESS') {
                        $nombre_paqueteria = 'DHL EXPRESS';
                    }
                }

                if (!isset($paqueterias[$nombre_paqueteria])) {
                    $paqueterias[$nombre_paqueteria] = array(
                        'amount_local' => 0,
                        'currency_local' => $paqueteria['currency_local'],
                        'provider' => $nombre_paqueteria,
                        'service_level_name' => '',
                        'service_level_code' => '',
                        'days' => 0,
                        'insurable' => false,
                        'out_of_area_service' => false,
                        'out_of_area_pricing' => 0,
                        'total_pricing' => 0
                    );
                }

                $paqueterias[$nombre_paqueteria]['amount_local'] += number_format($paqueteria['amount_local'], 2, '.', '');
                $paqueterias[$nombre_paqueteria]['service_level_name'] = $paqueteria['service_level_name'];
                $paqueterias[$nombre_paqueteria]['service_level_code'] = $paqueteria['service_level_code'];
                $paqueterias[$nombre_paqueteria]['days'] = $paqueteria['days'];
                $paqueterias[$nombre_paqueteria]['insurable'] = $paqueteria['insurable'];
                $paqueterias[$nombre_paqueteria]['out_of_area_service'] = $paqueteria['out_of_area_service'];
                $paqueterias[$nombre_paqueteria]['out_of_area_pricing'] += $paqueteria['out_of_area_pricing'];
                $paqueterias[$nombre_paqueteria]['total_pricing'] += number_format($paqueteria['total_pricing'], 2, '.', '');
            }
        }

        return $paqueterias;
    }
}
