<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/direccion_facturacion.php';
require '../usuario/decodeUsuario.php';

$response = array();

if (!isset($_POST['id_usuario'])) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$direcciones_facturacion = DireccionFacturacion::mdlGetDireccionesFacturacionById($id_usuario);

if (!$direcciones_facturacion) {
    $response['response'] = 'error';
    $response['data'] = 'No se encontraron direcciones de facturación';
    return;
}

$response['response'] = 'success';
$response['data'] = $direcciones_facturacion;
echo json_encode($response);
