<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/direccion_envio.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_direccion']) &&
    !isset($_POST['id_usuario']) &&
    !isset($_POST['cp']) &&
    !isset($_POST['estado']) &&
    !isset($_POST['delegacion']) &&
    !isset($_POST['colonia']) &&
    !isset($_POST['calle']) &&
    !isset($_POST['numero_exterior']) &&
    !isset($_POST['numero_interior']) &&
    !isset($_POST['numero_celular']) &&
    !isset($_POST['referencia']) &&
    !isset($_POST['nombre_receptor']) &&
    !isset($_POST['direccion_predeterminada']) &&
    !isset($_POST['activo'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';

    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {

    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';

    echo json_encode($response);
    return;
}

$id_direccion = $_POST['id_direccion'];
$cp = $_POST['cp'];
$estado = $_POST['estado'];
$delegacion = $_POST['delegacion'];
$colonia = $_POST['colonia'];
$calle = $_POST['calle'];
$numero_exterior = $_POST['numero_exterior'];
$numero_interior = $_POST['numero_interior'];
$numero_celular = $_POST['numero_celular'];
$referencia = $_POST['referencia'];
$nombre_receptor = $_POST['nombre_receptor'];
$activo = $_POST['activo'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('direccion_envio', $id_direccion));

$direccion_envio = DireccionEnvio::mdlUpdateDireccion(
    $id_usuario,
    $id_direccion,
    $cp,
    $estado,
    $delegacion,
    $colonia,
    $calle,
    $numero_exterior,
    (!$numero_interior) ? NULL : $numero_interior,
    $numero_celular,
    $referencia,
    $nombre_receptor,
    $activo
);

if (!$direccion_envio) {
    $response['response'] = 'error';
    $response['data'] = 'No se actualizó la dirección de envío';
}

$response['response'] = 'success';
$response['data'] = $direccion_envio;

echo json_encode($response);