<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/direccion_facturacion.php';
require '../../modelo/direcciones_sepomex.php';

$response = array();

if (
    !isset($_POST['cp'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$cp = $_POST['cp'];

$opciones_direccion = DireccionesSEPOMEX::mdlGetDireccionSEPOMEXByCP($cp);

$opciones['codigo_postal'] = [];
$opciones['ciudad'] = [];
$opciones['estado'] = [];
$opciones['municipio'] = [];
$opciones['colonias'] = [];

if (!$opciones_direccion) {
    $response['response'] = 'error';
    $response['data'] = $opciones;
    echo json_encode($response);
    return;
}

$ciudad = array();
$estado = array();
$municipio = array();
$asentamiento = array();
$codigo_postal = array();

foreach ($opciones_direccion as $key => $opcion) {
    $asentamiento[$key]['colonia'] = $opcion['d_asenta'];
}

$opciones['codigo_postal'] = $opciones_direccion[0]['d_codigo'];
$opciones['ciudad'] = $opciones_direccion[0]['d_cp'];
$opciones['estado'] = $opciones_direccion[0]['d_estado'];
$opciones['municipio'] = $opciones_direccion[0]['d_mnpio'];
$opciones['colonias'] = $asentamiento;

$response['response'] = 'success';
$response['data'] = $opciones;

echo json_encode($response);
return;