<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/ruta.php';
require '../../modelo/categoria.php';
require '../../modelo/subcategoria.php';

$categorias = Categoria::mdlGetAllCategorias();
$response = array();

if (!$categorias) {
    $response['response'] = 'error';
    $response['message'] = 'No se encontraron categorias';
    echo json_encode($response);
    return;
}

foreach ($categorias as $key => $value) {
    // $subcategorias = Subcategoria::mdlGetSubcategoriaByCategoria($value['id_categoria']);
    $categorias[$key]['imagen'] = Ruta::getRutaSitioAdministracion() . '/' . $value['imagen'];
    // $categorias[$key]['subcategorias'] = $subcategorias;
}

$response['response'] = 'success';
$response['data'] = $categorias;
echo json_encode($response);
