<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/catalogo.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

// VALIDAR SI LOS CAMPOS EXISTEN
if (!isset(
    $_POST['id_usuario'],
    $_POST['id_catalogo']
)) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

// VALIDAR SI EXISTE LA IMAGEN
if (!isset($_FILES['imagen']['name'])) {
    $response['response'] = 'error';
    $response['message'] = 'No hay imagen';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

// VALIDAR SI EL USUARIO EXISTE
if (!$id_usuario) {

    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';

    echo json_encode($response);
    return;
}

$id_catalogo = $_POST['id_catalogo'];

$imagen = $_FILES['imagen']['name'];

$extension = pathinfo($imagen, PATHINFO_EXTENSION);
$nombreImagen = uniqid() . "-" . $id_catalogo . '.' . $extension;

$imagenRuta = '../../assets/images/catalogo/' . $nombreImagen;

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('catalogo', $id_catalogo));

if (!move_uploaded_file($_FILES['imagen']['tmp_name'], $imagenRuta)) {
    $response['response'] = 'error';
    $response['message'] = 'No se pudo subir la imagen';
    echo json_encode($response);
    return;
}

$rutaFinal = "assets/images/catalogo/" . $nombreImagen;

if (!Catalogo::mdlUpdateCatalogoImagen($id_catalogo, $rutaFinal)) {
    $response['response'] = 'error';
    $response['message'] = 'No se pudo actualizar la imagen';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'catalogo', $id_catalogo, $id_usuario, $valor_anterior);
$response['response'] = 'success';
$response['data'] = true;
echo json_encode($response);
