<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/catalogo.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['nombre']) ||
    !isset($_POST['descripcion']) ||
    !isset($_POST['id_catalogo'])
) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);
if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$nombre = $_POST['nombre'];
$descripcion = $_POST['descripcion'];
$id_catalogo = $_POST['id_catalogo'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('catalogo', $id_catalogo));

$catalogo = Catalogo::mdlUpdateCatalogo($id_catalogo, $nombre, $descripcion);

if ($catalogo) {
    ModeloHistory::mdlAddNewRegister('update', 'catalogo', $id_catalogo, $id_usuario, $valor_anterior);
}

$response['response'] = 'success';
$response['data'] = $catalogo;
echo json_encode($response);