<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require '../../modelo/catalogo.php';
require '../../modelo/environment.php';
$response = array();

$url_servidor = Environment::getUrlServidor();

$catalogos = Catalogo::mdlGetCatalogos();

if (!$catalogos) {
    $response['response'] = 'error';
    $response['data'] = 'No se encontraron catalo$catalogos';
    return;
} 

foreach ($catalogos as $key => $catalogo) {
    $catalogos[$key]['imagen_portada'] = $url_servidor . $catalogo['imagen_portada'];
    $catalogos[$key]['link_pdf'] = $url_servidor . $catalogo['link_pdf'];
}

$response['response'] = 'success';
$response['data'] = $catalogos;
echo json_encode($response);