<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/catalogo.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (
    isset($_POST['id_usuario']) &&
    isset($_POST['id_catalogo'])
) {

    $id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);
    
    $id_catalogo = $_POST['id_catalogo'];
    
    $valor_anterior = json_encode(ModeloGlobal::mdlSelect('catalogo', $id_catalogo));

    $catalogo = Catalogo::mdlDeleteCatalogo($id_catalogo);

    if (!$catalogo) {
        $response['response'] = 'error';
        $response['data'] = 'No se eliminó el catálogo';
    } else {

        ModeloHistory::mdlAddNewRegister('delete', 'catalogo', $id_catalogo, $id_usuario, $valor_anterior);

        $response['response'] = 'success';
        $response['data'] = $catalogo;
    }
    echo json_encode($response);
    return;
} else {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}
