<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/carrito.php';
require '../../modelo/producto.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['id_carrito']) ||
    !isset($_POST['id_producto']) ||
    !isset($_POST['cantidad'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_carrito = $_POST['id_carrito'];
$id_producto = $_POST['id_producto'];
$cantidad = $_POST['cantidad'];

// $validar_stock_producto = Producto::mdlVerificarProductoStock($id_producto);

// if ($cantidad > $validar_stock_producto['stock']) {
//     $response['response'] = 'error';
//     $response['data'] = 'No hay suficiente stock para agregar este producto al carrito.';
//     echo json_encode($response);
//     return;
// }

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('carrito', $id_carrito));

$carrito = Carrito::mdlUpdateCarrito($id_carrito, $id_usuario, $id_producto, $cantidad);

if (!$carrito) {
    $response['response'] = 'error';
    $response['data'] = 'No se actualizó el producto en el carrito';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'carrito', $id_carrito, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = $carrito;

echo json_encode($response);