<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/producto.php';
require '../../modelo/carrito.php';
require '../../modelo/odoo_inventario.php';
require '../../modelo/almacenes_odoo.php';
require '../usuario/decodeUsuario.php';

if (!isset($_POST['id_usuario'])) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$carrito = Carrito::mdlGetCarritoByIdUsuario($id_usuario);

if ($carrito == false) {
    $response['response'] = 'error';
    $response['data'] = 'No se encontró el carrito del usuario.';
    echo json_encode($response);
    return;
}

$product_ids = [];

foreach ($carrito as $item) {
    $product_ids[] = intval($item['id_producto_odoo']);
}

$almacenes_odoo = AlmacenesOdoo::mdlGetIdAlmacenesOdoo();

$warehouse_ids = [];

foreach ($almacenes_odoo as $item) {
    $warehouse_ids[] = intval($item['id_odoo']);
}

$stocks = OdooInventario::getGlobalStock($product_ids, $warehouse_ids);

$response['response'] = 'success';
$response['data'] = $stocks;
echo json_encode($stocks);
