<?php

error_reporting(E_ALL);
error_reporting(-1);
ini_set('error_reporting', E_ALL);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/carrito.php';
require '../../modelo/producto_variacion.php';
require '../../modelo/tipo_variacion.php';
require '../../modelo/environment.php';
require '../usuario/decodeUsuario.php';
// require '../envio/costo_envio.php';
// require '../envio/costo_paqueteria.php';
require '../../modelo/almacenes_odoo.php';
require_once '../../modelo/odoo_inventario.php';
require '../../modelo/precio.php';

$response = array();
$url_servidor = Environment::getUrlServidor();

if (!isset($_POST['id_usuario'])) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

$carrito = Carrito::mdlGetCarritoByIdUsuario($id_usuario);

if (!$carrito) {
    $response['response'] = 'error';
    $response['data'] = 'No se encontraron carritos';
    echo json_encode($response);
    return;
}

$product_ids = [];

foreach ($carrito as $item) {
    $product_ids[] = intval($item['id_producto_odoo']);
}

$almacenes_odoo = AlmacenesOdoo::mdlGetIdAlmacenesOdoo();

$warehouse_ids = [];

foreach ($almacenes_odoo as $item) {
    $warehouse_ids[] = intval($item['id_odoo']);
}

$stocks = OdooInventario::getGlobalStock($product_ids, $warehouse_ids);

$subtotal = 0;

foreach ($carrito as $key => $value) {

    $imagenes = json_decode($value['imagenes']);

    $imagenes_url = array();
    foreach ($imagenes as $key_imagen => $imagen) {

        $imagenes_url[$key_imagen]['id_imagen'] = $imagen->id;
        $imagenes_url[$key_imagen]['url_imagen'] = $url_servidor . $imagen->url;
    }

    foreach ($stocks as $stock) {
        if ($value['id_producto_odoo'] == $stock['id']) {
            $carrito[$key]['stock'] = $stock['free_qty'];
            break;
        }
    }

    $carrito[$key]['imagenes'] = $imagenes_url;
    $producto_variacion = ProductoVariacion::mdlGetProductoVariacionByIdProducto($value['id_producto']);

    if ($producto_variacion && isset($producto_variacion['atributo_variacion'])) {
        $carrito[$key]['atributo_variacion'] = $producto_variacion['atributo_variacion'];
        $carrito[$key]['valor_atributo_variacion'] = $producto_variacion['valor_atributo_variacion'];
    }

    if ($producto_variacion && isset($producto_variacion['id_tipo_variacion'])) {
        $carrito[$key]['nombre_variacion'] = TipoVariacion::mdlGetTipoVariacionById($producto_variacion['id_tipo_variacion'])['nombre_variacion'];
    }


    $precio_regular = Precio::mdlGetPrecioById($value['id_precio']);
    
    $carrito[$key]['precio_regular'] = $precio_regular['precio'];
    $carrito[$key]['id_precio_descuento'] = $value['id_precio_descuento'];
    $carrito[$key]['precio_descuento'] = null;

    if ($value['id_precio_descuento'] !== null) {
        $precio_descuento = Precio::mdlGetPrecioById($producto['id_precio_descuento']);

        $carrito[$key]['precio_descuento'] = $precio_descuento['precio'];

        $suma = $value['cantidad'] * $precio_descuento['precio'];
    } else {
        $suma = $value['cantidad'] * $precio_regular['precio'];
    }

    $subtotal += $suma;

}

$response['response'] = 'success';
$response['data'] = $carrito;
$response['subtotal'] = $subtotal;

echo json_encode($response);
