<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/calificacion_producto.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (isset(
    $_POST['id_usuario'],
    $_POST['id_calificacion_producto']
)) {
    $id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);
    $id_calificacion_producto = $_POST['id_calificacion_producto'];

    $detalles = CalificacionProducto::mdlGetDetallesCalificacionProducto($id_calificacion_producto);

    $imagenes = $detalles['imagen_resena'] ? json_decode($detalles['imagen_resena'], true) : array();

    // Check if there are new images
    if (isset($_FILES['imagen']['name'])) {
        $imagen = $_FILES['imagen']['name'];

        $extension = pathinfo($imagen, PATHINFO_EXTENSION);
        $nombreImagen = uniqid() . $id_usuario . '.' . $extension;

        $imagenRuta = '../../asset/img/resenas/' . $nombreImagen;

        $valor_anterior = json_encode(ModeloGlobal::mdlSelect('calificacion_producto', $id_calificacion_producto));

        if (move_uploaded_file($_FILES['imagen']['tmp_name'], $imagenRuta)) {
            $imagenData['nombre'] = $nombreImagen;
            $imagenData['ruta'] = $imagenRuta;

            $imagenes[] = $imagenData;

            $response['response'] = 'success';
            $response['data'] = 'Imagen subida correctamente';
        } else {
            $response['response'] = 'error';
            $response['data'] = 'No se pudo subir la imagen';
        }
    }

    // Check if there are deleted images
    if (isset($_POST['deleted_images'])) {
        $deleted_images = json_decode($_POST['deleted_images'], true);

        foreach ($deleted_images as $deleted_image) {
            foreach ($imagenes as $key => $imagen) {
                if ($imagen['nombre'] === $deleted_image) {
                    unlink($imagen['ruta']);
                    unset($imagenes[$key]);
                }
            }
        }

        $response['response'] = 'success';
        $response['data'] = 'Imagen eliminada correctamente';
    }

    // Check if all images should be updated
    if (isset($_POST['all_images'])) {
        $all_images = json_decode($_POST['all_images'], true);

        foreach ($imagenes as $key => $imagen) {
            unlink($imagen['ruta']);
            unset($imagenes[$key]);
        }

        foreach ($all_images as $imagen) {
            $extension = pathinfo($imagen, PATHINFO_EXTENSION);
            $nombreImagen = uniqid() . $id_usuario . '.' . $extension;

            $imagenRuta = '../../asset/img/resenas/' . $nombreImagen;

            if (copy($imagen, $imagenRuta)) {
                $imagenData['nombre'] = $nombreImagen;
                $imagenData['ruta'] = $imagenRuta;

                $imagenes[] = $imagenData;
            }
        }

        $response['response'] = 'success';
        $response['data'] = 'Todas las imágenes actualizadas correctamente';
    }

    $imagenesArray = json_encode($imagenes);

    if (CalificacionProducto::mdlUpdateCalificacionProductoImagen($id_calificacion_producto, $imagenesArray)) {
        ModeloHistory::mdlAddNewRegister('update', 'calificacion_producto', $id_calificacion_producto, $id_usuario, $valor_anterior);

        echo json_encode($response);
        return;
    } else {
        $response['response'] = 'error';
        $response['data'] = 'No se pudo actualizar la imagen';
    }
} else {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
}

echo json_encode($response);
