<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/calificacion_producto.php';
require '../../modelo/environment.php';
$response = array();

$resenas = CalificacionProducto::mdlGetCalificacionProductosResenas();

if (!$resenas) {
    $response['response'] = 'error';
    $response['data'] = 'No se encontraron resenas';
    echo json_encode($response);
    return;
}

foreach ($resenas as $key => $resena) {

    if (is_null($resena['uid_google']) && is_null($resena['uid_facebook'])) {
        $resenas[$key]['foto_perfil'] = Environment::getUrlServidor() . $resena['foto_perfil'];
    }

    unset($resenas[$key]['uid_google']);
    unset($resenas[$key]['uid_facebook']);

    // $resenas[$key]['foto_perfil'] = Environment::getUrlServidor() . $resena['foto_perfil'];

    if($resena['imagen_resena'] != null) {
        $imagenes = json_decode($resena['imagen_resena']);
        $imagenes_url = array();
        $url_servidor = Environment::getUrlServidor();
        
        foreach ($imagenes as $key_imagen => $imagen) {
            $imagenes_url[$key_imagen]['id_imagen'] = $imagen->id;
            $imagenes_url[$key_imagen]['url_imagen'] = $url_servidor . $imagen->url;
        }
    }

    $resenas[$key]['imagen_resena'] = $imagenes_url;
}

$response['response'] = 'success';
$response['data'] = $resenas;
echo json_encode($response);
return;