<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/calificacion_producto.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';

$response = array();

if (
    isset($_POST['id_usuario']) &&
    isset($_POST['id_producto']) &&
    isset($_POST['calificacion'])
) {
    $id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

    if (!$id_usuario) {
        $response['response'] = 'error';
        $response['data'] = 'Id del usuario incorrecto.';
        echo json_encode($response);
        return;
    }

    $id_producto = $_POST['id_producto'];
    $calificacion = $_POST['calificacion'];
    $comentario = NULL;
    
    if (isset($_POST['comentario']) && !empty($_POST['comentario'])) {
        $comentario = $_POST['comentario'];
    }

    $calificacion_producto = CalificacionProducto::mdlAddCalificacionProducto($id_usuario, $id_producto, $calificacion, $comentario, NULL);

    if (!$calificacion_producto) {
        $response['response'] = 'error';
        $response['data'] = 'No se agregó la calificación del producto.';
    } else {
        ModeloHistory::mdlAddNewRegister('create', 'calificacion_producto', $calificacion_producto, $id_usuario, NULL);
        $response['response'] = 'success';
        $response['data'] = $calificacion_producto;
    }

    echo json_encode($response);
    return;
} else {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}
