<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('error_reporting', E_ALL);

require '../../modelo/calificacion_producto.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (!isset($_POST['id_usuario']) || 
    !isset($_POST['id_calificacion_producto'])) 
{
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

if (!isset($_FILES['imagen']['name'])) {
    $response['response'] = 'error';
    $response['data'] = 'No hay foto de resena';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_calificacion_producto = $_POST['id_calificacion_producto'];

$detalles = CalificacionProducto::mdlGetDetallesCalificacionProducto($id_calificacion_producto);

if (!$detalles) {
    $response['response'] = 'error';
    $response['data'] = 'No se encontró la calificación';
    echo json_encode($response);
    return;
}

$imagen = $_FILES['imagen']['name'];

$extension = pathinfo($imagen, PATHINFO_EXTENSION);
$nombreImagen = uniqid() . $id_usuario . '.' . $extension;

$imagenRuta = '../../assets/images/resenas/' . $nombreImagen;

if (!move_uploaded_file($_FILES['imagen']['tmp_name'], $imagenRuta)) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo subir la imagen';
    echo json_encode($response);
    return;
}

$id_imagen = explode(".", $nombreImagen)[0];
$imagenData['id_imagen'] = $id_imagen;
// $imagenData['url_imagen'] = str_replace('\/,', '/', $imagenRuta);
$imagenData['url_imagen'] = 'assets/images/resenas/' . $nombreImagen;

$imagenes = is_null($detalles['imagen_resena']) ? array() : json_decode($detalles['imagen_resena'], true);
$imagenes[] = $imagenData;
$imagenesArray = json_encode($imagenes);

if (CalificacionProducto::mdlUpdateCalificacionProductoImagen($id_calificacion_producto, $imagenesArray)) {
    $response['response'] = 'success';
    $response['data'] = 'Imagen subida correctamente';
    echo json_encode($response);
    return;
}