<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/banner.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (
    !isset($_POST['id_banner']) ||
    !isset($_POST['id_usuario'])
) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_banner = $_POST['id_banner'];

// Verificar si es el ultimo banner, en caso de serlo, no se puede eliminar
$total_banners = Banner::mdlGetTotalBanners();
if ($total_banners['total'] == 1) {
    $response['response'] = 'error';
    $response['message'] = 'No se puede eliminar el último banner';
    echo json_encode($response);
    return;
}

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('banner', $id_banner));

$banner = Banner::mdlDeleteBanner($id_banner);

if (!$banner) {
    $response['response'] = 'error';
    $response['message'] = 'No se eliminó el banner';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('delete', 'banner', $id_banner, $id_usuario, $valor_anterior);
$response['response'] = 'success';
$response['data'] = $banner;
echo json_encode($response);
