<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/ad_header.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['titulo']) ||
    !isset($_POST['url']) ||
    !isset($_POST['color']) ||
    !isset($_POST['id_ad_header']) ||
    !isset($_POST['activo'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$titulo = $_POST['titulo'];
$url = $_POST['url'];
$color = $_POST['color'];
$activo = $_POST['activo'];
$id_ad_header = $_POST['id_ad_header'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('ad_header', $id_ad_header));

$ad_header = AdHeader::mdlUpdateAdHeader($id_ad_header, $titulo, $url, $color, $activo);

if (!$ad_header) {
    $response['response'] = 'error';
    $response['data'] = 'No se actualizo el ad_header';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'ad_header', $id_ad_header, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = $ad_header;

echo json_encode($response);
return;
