<?php
/**
 * Copyright (c) 2015-present, Facebook, Inc. All rights reserved.
 *
 * You are hereby granted a non-exclusive, worldwide, royalty-free license to
 * use, copy, modify, and distribute this software in source code or binary
 * form for use in connection with the web services and APIs provided by
 * Facebook.
 *
 * As with any software that integrates with the Facebook platform, your use
 * of this software is subject to the Facebook Developer Principles and
 * Policies [http://developers.facebook.com/policy/]. This copyright notice
 * shall be included in all copies or substantial portions of the software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */

namespace FacebookAds\Object\Values;

use FacebookAds\Enum\AbstractEnum;

/**
 * This class is auto-generated.
 *
 * For any issues or feature requests related to this class, please let us know
 * on github and we'll fix in our codegen framework. We'll not be able to accept
 * pull request for this class.
 *
 * @method static PageSavedFilterSectionValues getInstance()
 */
class PageSavedFilterSectionValues extends AbstractEnum {

  const ACTIVE_FUNDRAISERS = 'ACTIVE_FUNDRAISERS';
  const ADS_CANVAS = 'ADS_CANVAS';
  const ADS_POSTS = 'ADS_POSTS';
  const ALLOWED = 'ALLOWED';
  const ALL_REFERENCE_FILES = 'ALL_REFERENCE_FILES';
  const ARCHIVED_EVENTS = 'ARCHIVED_EVENTS';
  const ATTRIBUTIONS = 'ATTRIBUTIONS';
  const AUDIO_RELEASES = 'AUDIO_RELEASES';
  const BLOCKED = 'BLOCKED';
  const BRANDED_CONTENT = 'BRANDED_CONTENT';
  const BRANDED_CONTENT_CREATOR = 'BRANDED_CONTENT_CREATOR';
  const BRANDED_CONTENT_SUSPECTED = 'BRANDED_CONTENT_SUSPECTED';
  const CANDIDATE_VIDEOS = 'CANDIDATE_VIDEOS';
  const CHEX_COMPLETED_ORDERS = 'CHEX_COMPLETED_ORDERS';
  const CHEX_PENDING_ORDERS = 'CHEX_PENDING_ORDERS';
  const CLAIMED = 'CLAIMED';
  const COMMERCE_COLLECTIONS = 'COMMERCE_COLLECTIONS';
  const COMMERCE_MERCHANT_SETTINGS = 'COMMERCE_MERCHANT_SETTINGS';
  const COMMERCE_PAST_ORDERS = 'COMMERCE_PAST_ORDERS';
  const COMMERCE_PENDING_ORDERS = 'COMMERCE_PENDING_ORDERS';
  const COMMERCE_PLATFORM_SETTINGS = 'COMMERCE_PLATFORM_SETTINGS';
  const COMMERCE_PRODUCTS = 'COMMERCE_PRODUCTS';
  const COMMERCE_SHOP_LINK = 'COMMERCE_SHOP_LINK';
  const CONTENT_TESTS = 'CONTENT_TESTS';
  const CREATOR_STUDIO = 'CREATOR_STUDIO';
  const CREATOR_STUDIO_ALL_MATCHES = 'CREATOR_STUDIO_ALL_MATCHES';
  const CREATOR_STUDIO_ALL_REFERENCE_FILES = 'CREATOR_STUDIO_ALL_REFERENCE_FILES';
  const CREATOR_STUDIO_BLOCKED = 'CREATOR_STUDIO_BLOCKED';
  const CREATOR_STUDIO_COLLECT_AD_EARNINGS = 'CREATOR_STUDIO_COLLECT_AD_EARNINGS';
  const CREATOR_STUDIO_DISPUTES = 'CREATOR_STUDIO_DISPUTES';
  const CREATOR_STUDIO_PUBLISHED_ALL_REFERENCE_FILES = 'CREATOR_STUDIO_PUBLISHED_ALL_REFERENCE_FILES';
  const CREATOR_STUDIO_PUBLISHED_BLOCKED = 'CREATOR_STUDIO_PUBLISHED_BLOCKED';
  const CREATOR_STUDIO_PUBLISHED_DISPUTES = 'CREATOR_STUDIO_PUBLISHED_DISPUTES';
  const CREATOR_STUDIO_PUBLISHED_MANUAL_REVIEW = 'CREATOR_STUDIO_PUBLISHED_MANUAL_REVIEW';
  const CREATOR_STUDIO_PUBLISHED_TRACKED = 'CREATOR_STUDIO_PUBLISHED_TRACKED';
  const CREATOR_STUDIO_REFERENCE_CONFLICTS = 'CREATOR_STUDIO_REFERENCE_CONFLICTS';
  const CREATOR_STUDIO_REFERENCE_POSSIBLE_CONFLICTS = 'CREATOR_STUDIO_REFERENCE_POSSIBLE_CONFLICTS';
  const CREATOR_STUDIO_REFERENCE_RESOLUTIONS = 'CREATOR_STUDIO_REFERENCE_RESOLUTIONS';
  const CREATOR_STUDIO_TAKEDOWNS = 'CREATOR_STUDIO_TAKEDOWNS';
  const CREATOR_STUDIO_TAKEDOWN_REQUESTS = 'CREATOR_STUDIO_TAKEDOWN_REQUESTS';
  const CREATOR_STUDIO_TRACKED = 'CREATOR_STUDIO_TRACKED';
  const CROSSPOSTED_VIDEOS = 'CROSSPOSTED_VIDEOS';
  const DISPUTES = 'DISPUTES';
  const DONATIONS_SETTINGS = 'DONATIONS_SETTINGS';
  const DRAFTS = 'DRAFTS';
  const DRAFT_EVENTS = 'DRAFT_EVENTS';
  const DRAFT_FUNDRAISERS = 'DRAFT_FUNDRAISERS';
  const ENDED_FUNDRAISERS = 'ENDED_FUNDRAISERS';
  const EXPIRED_POSTS = 'EXPIRED_POSTS';
  const EXPIRING_POSTS = 'EXPIRING_POSTS';
  const GEM_PRODUCER_DASHBOARD = 'GEM_PRODUCER_DASHBOARD';
  const IA_REGIWALL_SETTINGS = 'IA_REGIWALL_SETTINGS';
  const INSTANT_ARTICLES = 'INSTANT_ARTICLES';
  const INSTANT_ARTICLES_CTA_MANAGEMENT = 'INSTANT_ARTICLES_CTA_MANAGEMENT';
  const INSTANT_ARTICLES_DEVELOPMENT = 'INSTANT_ARTICLES_DEVELOPMENT';
  const INSTANT_ARTICLES_MONETIZATION = 'INSTANT_ARTICLES_MONETIZATION';
  const INSTANT_ARTICLES_SAMPLE = 'INSTANT_ARTICLES_SAMPLE';
  const INSTANT_ARTICLES_SETTINGS = 'INSTANT_ARTICLES_SETTINGS';
  const INSTANT_ARTICLES_SIGN_UP = 'INSTANT_ARTICLES_SIGN_UP';
  const INSTANT_ARTICLES_TRAFFIC_LIFT = 'INSTANT_ARTICLES_TRAFFIC_LIFT';
  const INVOICES_ACTIVE = 'INVOICES_ACTIVE';
  const INVOICES_HISTORY = 'INVOICES_HISTORY';
  const JOB_APPLICATIONS = 'JOB_APPLICATIONS';
  const JOB_POSTS = 'JOB_POSTS';
  const LEAD_ADS_CRM_SETUP = 'LEAD_ADS_CRM_SETUP';
  const LEAD_ADS_CUSTOM_CRM_SETUP = 'LEAD_ADS_CUSTOM_CRM_SETUP';
  const LEAD_ADS_DRAFT_FORMS = 'LEAD_ADS_DRAFT_FORMS';
  const LEAD_ADS_FORMS = 'LEAD_ADS_FORMS';
  const LIVE_BROADCASTS = 'LIVE_BROADCASTS';
  const MANUAL_CLAIMS = 'MANUAL_CLAIMS';
  const MANUAL_CLAIM_FACEBOOK_VIDEOS = 'MANUAL_CLAIM_FACEBOOK_VIDEOS';
  const MANUAL_CLAIM_INSTAGRAM_VIDEOS = 'MANUAL_CLAIM_INSTAGRAM_VIDEOS';
  const MANUAL_REVIEW = 'MANUAL_REVIEW';
  const MATCH_RULES = 'MATCH_RULES';
  const MONETIZED_VIDEOS = 'MONETIZED_VIDEOS';
  const NEWS_SUBSCRIPTIONS = 'NEWS_SUBSCRIPTIONS';
  const NEWS_SUBSCRIPTIONS_PUBLISHER_INSIGHTS = 'NEWS_SUBSCRIPTIONS_PUBLISHER_INSIGHTS';
  const NEWS_SUBSCRIPTIONS_PUBLISHER_TEST_USERS = 'NEWS_SUBSCRIPTIONS_PUBLISHER_TEST_USERS';
  const NEW_MATCHES = 'NEW_MATCHES';
  const PENDING_PROFILE_PICTURE_FRAMES = 'PENDING_PROFILE_PICTURE_FRAMES';
  const PLAYLISTS = 'PLAYLISTS';
  const PLAYLIST_DETAILS = 'PLAYLIST_DETAILS';
  const POLLS_COMPOSER = 'POLLS_COMPOSER';
  const POSTS_CONFIG = 'POSTS_CONFIG';
  const POST_IDEAS = 'POST_IDEAS';
  const PREMIUM_MUSIC_VIDEOS = 'PREMIUM_MUSIC_VIDEOS';
  const PUBLISHED_EVENTS = 'PUBLISHED_EVENTS';
  const PUBLISHED_POSTS = 'PUBLISHED_POSTS';
  const PUBLISHED_PROFILE_PICTURE_FRAMES = 'PUBLISHED_PROFILE_PICTURE_FRAMES';
  const QR_CODE = 'QR_CODE';
  const READY_FUNDRAISERS = 'READY_FUNDRAISERS';
  const REFERENCE_CONFLICTS = 'REFERENCE_CONFLICTS';
  const REFERENCE_FILES = 'REFERENCE_FILES';
  const REFERENCE_POSSIBLE_CONFLICTS = 'REFERENCE_POSSIBLE_CONFLICTS';
  const REFERENCE_RESOLUTIONS = 'REFERENCE_RESOLUTIONS';
  const REGISTRATIONS = 'REGISTRATIONS';
  const REPORTED = 'REPORTED';
  const REWARD_PROGRAM = 'REWARD_PROGRAM';
  const REWARD_PROGRAM_COLLATERAL_MANAGEMENT = 'REWARD_PROGRAM_COLLATERAL_MANAGEMENT';
  const REWARD_PROGRAM_TRANSACTION_HISTORY = 'REWARD_PROGRAM_TRANSACTION_HISTORY';
  const SCHEDULED_EVENTS = 'SCHEDULED_EVENTS';
  const SCHEDULED_POSTS = 'SCHEDULED_POSTS';
  const SEASONS = 'SEASONS';
  const SEASON_DETAILS = 'SEASON_DETAILS';
  const SOUNDS_COLLECTION = 'SOUNDS_COLLECTION';
  const SOUND_RECORDINGS = 'SOUND_RECORDINGS';
  const STORY_ARCHIVE = 'STORY_ARCHIVE';
  const STREAMER_DASHBOARD = 'STREAMER_DASHBOARD';
  const TAKEDOWNS = 'TAKEDOWNS';
  const TOURS = 'TOURS';
  const TRACKED = 'TRACKED';
  const UNSENT_REPORTS = 'UNSENT_REPORTS';
  const VIDEOS = 'VIDEOS';
  const VIDEOS_COPYRIGHT = 'VIDEOS_COPYRIGHT';
}
