<?php

require_once 'conexion.php';

class ZonaExtendidaDHL
{
    public static function mdlGetZonasExtendidasDHL()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM zonas_extendidas_dhl WHERE activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetZonaExtendidaDHLById($id_zona_extendida_dhl)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM zonas_extendidas_dhl WHERE id_zona_extendida_dhl = :id_zona_extendida_dhl AND activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_zona_extendida_dhl', $id_zona_extendida_dhl);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlAddZonaExtendidaDHL($cp)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO zonas_extendidas_dhl (cp) VALUES (:cp)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':cp', $cp);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateZonaExtendidaDHL($id_zona_extendida_dhl, $cp)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE zonas_extendidas_dhl SET cp = :cp WHERE id_zona_extendida_dhl = :id_zona_extendida_dhl";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_zona_extendida_dhl', $id_zona_extendida_dhl);
        $stmt->bindParam(':cp', $cp);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlDeleteZonaExtendidaDHL($id_zona_extendida_dhl)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM zonas_extendidas_dhl WHERE id_zona_extendida_dhl = :id_zona_extendida_dhl";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_zona_extendida_dhl', $id_zona_extendida_dhl);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateActivoZonaExtendidaDHL($id_zona_extendida_dhl, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE zonas_extendidas_dhl SET activo = :activo WHERE id_zona_extendida_dhl = :id_zona_extendida_dhl";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_zona_extendida_dhl', $id_zona_extendida_dhl);
        $stmt->bindParam(':activo', $activo);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }
}