<?php

require_once 'conexion.php';

class Respuesta
{
    public static function mdlAddRespuesta($id_pregunta, $id_usuario, $respuesta)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "INSERT INTO respuesta (id_pregunta, id_usuario, respuesta) VALUES (:id_pregunta, :id_usuario, :respuesta)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_pregunta', $id_pregunta, PDO::PARAM_INT);
        $stmt->bindParam(':id_usuario', $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(':respuesta', $respuesta, PDO::PARAM_STR);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetRespuesta($id_respuesta)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM respuesta WHERE id_respuesta = :id_respuesta";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_respuesta', $id_respuesta, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetRespuestas($activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM respuesta WHERE activo = :activo";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':activo', $activo, PDO::PARAM_BOOL);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateRespuesta($id_respuesta, $id_pregunta, $id_usuario, $respuesta, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE respuesta SET id_pregunta = :id_pregunta, id_usuario = :id_usuario, respuesta = :respuesta, activo = :activo WHERE id_respuesta = :id_respuesta";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_respuesta', $id_respuesta, PDO::PARAM_INT);
        $stmt->bindParam(':id_pregunta', $id_pregunta, PDO::PARAM_INT);
        $stmt->bindParam(':id_usuario', $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(':respuesta', $respuesta, PDO::PARAM_STR);
        $stmt->bindParam(':activo', $activo, PDO::PARAM_BOOL);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateSoloRespuesta($id_respuesta, $respuesta){
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE respuesta SET respuesta = :respuesta WHERE id_respuesta = :id_respuesta";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_respuesta', $id_respuesta, PDO::PARAM_INT);
        $stmt->bindParam(':respuesta', $respuesta, PDO::PARAM_STR);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateEstadoRespuesta($id_respuesta, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE respuesta SET activo = :activo WHERE id_respuesta = :id_respuesta";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_respuesta', $id_respuesta, PDO::PARAM_INT);
        $stmt->bindParam(':activo', $activo, PDO::PARAM_BOOL);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlDeleteRespuesta($id_respuesta)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "DELETE FROM respuesta WHERE id_respuesta = :id_respuesta";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_respuesta', $id_respuesta, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }
}