<?php

require_once 'conexion.php';

class ProductoOrden
{
    public static function mdlGetProductoOrdenById($id_usuario)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT producto_orden.*, orden.numero_orden, estado_orden.nombre 
                FROM producto_orden 
                JOIN orden ON producto_orden.id_orden = orden.id_orden 
                JOIN estado_orden ON orden.id_estado_orden = estado_orden.id_estado_orden
                JOIN producto ON producto_orden.id_producto = producto.id_producto
                WHERE orden.id_usuario = :id_usuario";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_usuario", $id_usuario);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetProductoOrdenByIdOrden($id_orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT producto_orden.*, producto.id_producto_odoo, producto.nombre, producto.imagenes, producto.id_precio, producto.id_precio_descuento, producto.url_pagina, precio.precio, precio.etiqueta, categoria.color AS color_categoria
                FROM producto_orden 
                LEFT JOIN orden ON producto_orden.id_orden = orden.id_orden
                LEFT JOIN producto ON producto_orden.id_producto = producto.id_producto
                LEFT JOIN precio ON producto_orden.id_precio = precio.id_precio
                LEFT JOIN producto_categoria ON producto.id_producto = producto_categoria.id_producto
                LEFT JOIN categoria ON producto_categoria.id_categoria = categoria.id_categoria
                WHERE orden.id_orden = :id_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_orden", $id_orden);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlAddProductoOrden($id_producto, $id_orden, $precio, $numero_serie_equipo, $cantidad, $id_almacen_odoo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO producto_orden (id_producto, id_orden, id_precio, numero_serie_equipo, cantidad, id_almacen_odoo) VALUES (:id_producto, :id_orden, :id_precio, :numero_serie_equipo, :cantidad, :id_almacen_odoo)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_producto", $id_producto);
        $stmt->bindParam(":id_orden", $id_orden);
        $stmt->bindParam(":id_precio", $precio);
        $stmt->bindParam(":numero_serie_equipo", $numero_serie_equipo);
        $stmt->bindParam(":cantidad", $cantidad);
        $stmt->bindParam(":id_almacen_odoo", $id_almacen_odoo);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateProductoOrden($id_producto_orden, $id_producto, $id_orden, $numero_serie_equipo, $cantidad, $id_almacen_odoo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE producto_orden SET id_producto = :id_producto, id_orden = :id_orden, numero_serie_equipo = :numero_serie_equipo, cantidad = :cantidad, id_almacen_odoo = :id_almacen_odoo WHERE id_producto_orden = :id_producto_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_producto", $id_producto);
        $stmt->bindParam(":id_orden", $id_orden);
        $stmt->bindParam(":numero_serie_equipo", $numero_serie_equipo);
        $stmt->bindParam(":cantidad", $cantidad);
        $stmt->bindParam(":id_almacen_odoo", $id_almacen_odoo);
        $stmt->bindParam(":id_producto_orden", $id_producto_orden);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlDeleteProductoOrden($id_producto_orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM producto_orden WHERE id_producto_orden = :id_producto_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_producto_orden", $id_producto_orden);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }
}
