<?php

require_once 'conexion.php';

class Precio
{
    public static function mdlGetPrecios($activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM precio WHERE activo = :activo";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":activo", $activo, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetPrecioById($id_precio)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM precio WHERE id_precio = :id_precio AND activo = 1";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":id_precio", $id_precio, PDO::PARAM_INT);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlAddPrecio($precio_con_iva, $precio_sin_iva, $etiqueta, $id_producto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO precio (precio, precio_iva, etiqueta, id_producto) VALUES (:precio, :precio_iva, :etiqueta, :id_producto)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":precio", $precio_con_iva);
        $stmt->bindParam(":precio_iva", $precio_sin_iva);
        $stmt->bindParam(":etiqueta", $etiqueta);
        $stmt->bindParam(":id_producto", $id_producto);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdatePrecio($id_precio, $precio, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE precio SET precio = :precio, activo = :activo WHERE id_precio = :id_precio";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":precio", $precio);
        $stmt->bindParam(":activo", $activo, PDO::PARAM_INT);
        $stmt->bindParam(":id_precio", $id_precio, PDO::PARAM_INT);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlDeletePrecio($id_precio)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM precio WHERE id_precio = :id_precio";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":id_precio", $id_precio, PDO::PARAM_INT);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateActivoPrecio($id_precio, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE precio SET activo = :activo WHERE id_precio = :id_precio";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":activo", $activo, PDO::PARAM_INT);
        $stmt->bindParam(":id_precio", $id_precio, PDO::PARAM_INT);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetPrecioEnvioByOrden($id_orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT precio.precio FROM guia_envio_orden 
                LEFT JOIN guia_envio_producto ON guia_envio_orden.id_guia_envio_producto = guia_envio_producto.id_guia_envio_producto 
                LEFT JOIN precio ON guia_envio_producto.id_precio = precio.id_precio 
                WHERE guia_envio_orden.id_orden = :id_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_orden", $id_orden, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }
}