<?php

require_once 'conexion.php';

class PagoSoporteTecnico
{
    public static function mdlGetPagos($activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM pago_soporte_tecnico WHERE activo = :activo";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":activo", $activo, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlAddPagoCitaSoporteTecnico($id_cita_soporte_tecnico, $id_transaccion, $pasarela_pago, $metodo_pago, $moneda, $cantidad_pago, $nombre_comprador, $correo_comprador, $estado_pago, $user_agent, $ip)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO pago_soporte_tecnico (id_cita_soporte_tecnico, id_transaccion, pasarela_pago, metodo_pago, moneda, cantidad_pago, nombre_comprador, correo_comprador, estado_pago, user_agent, ip) VALUES (:id_cita_soporte_tecnico, :id_transaccion, :pasarela_pago, :metodo_pago, :moneda, :cantidad_pago, :nombre_comprador, :correo_comprador, :estado_pago, :user_agent, :ip)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_cita_soporte_tecnico", $id_cita_soporte_tecnico);
        $stmt->bindParam(":id_transaccion", $id_transaccion);
        $stmt->bindParam(":pasarela_pago", $pasarela_pago);
        $stmt->bindParam(":metodo_pago", $metodo_pago);
        $stmt->bindParam(":moneda", $moneda);
        $stmt->bindParam(":cantidad_pago", $cantidad_pago);
        $stmt->bindParam(":nombre_comprador", $nombre_comprador);
        $stmt->bindParam(":correo_comprador", $correo_comprador);
        $stmt->bindParam(":estado_pago", $estado_pago);
        $stmt->bindParam(":user_agent", $user_agent);
        $stmt->bindParam(":ip", $ip);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;

        return $response;
    }

    public static function mdlGetPagoByIdCita($id_cita_soporte_tecnico)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM pago_soporte_tecnico WHERE id_cita_soporte_tecnico = :id_cita_soporte_tecnico";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_cita_soporte_tecnico", $id_cita_soporte_tecnico);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetTotalIngresosEntreFechas($fecha_inicial, $fecha_final)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT SUM(cantidad_pago) as total FROM pago_soporte_tecnico WHERE DATE(fecha_pago) BETWEEN :fecha_inicial AND :fecha_final";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":fecha_inicial", $fecha_inicial);
        $stmt->bindParam(":fecha_final", $fecha_final);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }
}
