<?php

require_once 'conexion.php';

class GuiaProductoOrden
{
    public static function mdlGetGuiaProductoOrdenByIdPaqueteria($id_paqueteria)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM guia_producto_orden WHERE id_paqueteria = :id_paqueteria";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_paqueteria", $id_paqueteria, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }
    
    public static function mdlGetGuiaProductoOrdenByNumeroRastreo($numero_rastreo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM guia_producto_orden WHERE numero_rastreo = :numero_rastreo";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":numero_rastreo", $numero_rastreo);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    // public static function mdlAddGuiaProductoOrden($id_paqueteria, $numero_rastreo)
    // {
    //     $conexion = new Conexion();
    //     $db = $conexion->get_connection();

    //     $sql = "INSERT INTO guia_producto_orden (id_paqueteria, numero_rastreo) VALUES (:id_paqueteria, :numero_rastreo)";

    //     $stmt = $db->prepare($sql);

    //     $stmt->bindParam(":id_paqueteria", $id_paqueteria, PDO::PARAM_INT);
    //     $stmt->bindParam(":numero_rastreo", $numero_rastreo);

    //     $stmt->execute();

    //     $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

    //     $db = null;
        
    //     return $response;
    // }

    public static function mdlUpdateGuiaProductoOrden($id_guia_producto_orden, $id_paqueteria, $numero_rastreo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE guia_producto_orden SET id_paqueteria = :id_paqueteria, numero_rastreo = :numero_rastreo WHERE id_guia_producto_orden = :id_guia_producto_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_paqueteria", $id_paqueteria, PDO::PARAM_INT);
        $stmt->bindParam(":numero_rastreo", $numero_rastreo);
        $stmt->bindParam(":id_guia_producto_orden", $id_guia_producto_orden, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlDeleteGuiaProductoOrden($id_guia_producto_orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM guia_producto_orden WHERE id_guia_producto_orden = :id_guia_producto_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_guia_producto_orden", $id_guia_producto_orden, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }
    //A partir de aquí son los nuevo smodelos hasta que se actualicen todos los controaldores en donde se utilizan los anteirores

    public static function mdlAddGuiaProductoOrden($id_guia_envio_orden, $id_producto_orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO guia_producto_orden (id_guia_envio_orden, id_producto_orden) VALUES (:id_guia_envio_orden, :id_producto_orden)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_guia_envio_orden", $id_guia_envio_orden);
        $stmt->bindParam(":id_producto_orden", $id_producto_orden);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;
        
        return $response;
    }

    // public static function mdlGetDetalleCostoEnvio(){}
}