<?php

require_once 'conexion.php';

class GuiaEnvioProducto
{
    public static function mdlGetAllGuiaEnvioProducto()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM guia_envio_producto";

        $stmt = $db->prepare($sql);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetGuiaEnvioProductoById($id_guia_envio_producto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT guia_envio_producto.*, precio.precio, paqueteria.nombre
                FROM guia_envio_producto INNER JOIN precio ON guia_envio_producto.id_precio = precio.id_precio INNER JOIN paqueteria ON guia_envio_producto.id_paqueteria = paqueteria.id_paqueteria
                WHERE id_guia_envio_producto = :id_guia_envio_producto";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":id_guia_envio_producto", $id_guia_envio_producto, PDO::PARAM_INT);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlAddGuiaEnvioProducto($id_paqueteria, $nombre, $id_precio)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO guia_envio_producto (id_paqueteria, nombre, id_precio) VALUES (:id_paqueteria, :nombre, :id_precio)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":id_paqueteria", $id_paqueteria, PDO::PARAM_INT);
        $stmt->bindParam(":nombre", $nombre);
        $stmt->bindParam(":id_precio", $id_precio, PDO::PARAM_INT);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateGuiaEnvioProducto($id_guia_envio_producto, $id_paqueteria, $nombre, $descripcion, $id_precio, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE guia_envio_producto 
                SET id_paqueteria = :id_paqueteria, nombre = :nombre, descripcion = :descripcion, id_precio = :id_precio, activo = :activo 
                WHERE id_guia_envio_producto = :id_guia_envio_producto";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":id_paqueteria", $id_paqueteria, PDO::PARAM_INT);
        $stmt->bindParam(":nombre", $nombre);
        $stmt->bindParam(":descripcion", $descripcion);
        $stmt->bindParam(":id_precio", $id_precio, PDO::PARAM_INT);
        $stmt->bindParam(":activo", $activo, PDO::PARAM_INT);
        $stmt->bindParam(":id_guia_envio_producto", $id_guia_envio_producto, PDO::PARAM_INT);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlDeleteGuiaEnvioProducto($id_guia_envio_producto)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM guia_envio_producto WHERE id_guia_envio_producto = :id_guia_envio_producto";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":id_guia_envio_producto", $id_guia_envio_producto, PDO::PARAM_INT);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlGetGuiaEnvioProductoByIdCostoOdoo($id_costo_odoo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT id_guia_envio_producto FROM guia_envio_producto WHERE id_costo_odoo = :id_costo_odoo";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(":id_costo_odoo", $id_costo_odoo);
        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }
}
