<?php

require_once 'conexion.php';

class EstadoReclamo
{
    public static function mdlAddEstadoReclamo($nombre, $descripcion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "INSERT INTO estado_reclamo (nombre, descripcion) VALUES (:nombre, :descripcion)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':nombre', $nombre, PDO::PARAM_STR);
        $stmt->bindParam(':descripcion', $descripcion, PDO::PARAM_STR);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetEstadoReclamo($id_estado_reclamo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM estado_reclamo WHERE id_estado_reclamo = :id_estado_reclamo";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_estado_reclamo', $id_estado_reclamo, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetEstadosReclamo($activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT * FROM estado_reclamo WHERE activo = :activo";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':activo', $activo, PDO::PARAM_BOOL);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateEstadoReclamo($id_estado_reclamo, $nombre, $descripcion, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE estado_reclamo SET nombre = :nombre, descripcion = :descripcion, activo = :activo WHERE id_estado_reclamo = :id_estado_reclamo";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_estado_reclamo', $id_estado_reclamo, PDO::PARAM_INT);
        $stmt->bindParam(':nombre', $nombre, PDO::PARAM_STR);
        $stmt->bindParam(':descripcion', $descripcion, PDO::PARAM_STR);
        $stmt->bindParam(':activo', $activo, PDO::PARAM_BOOL);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateEstadoEstadoReclamo($id_estado_reclamo, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE estado_reclamo SET activo = :activo WHERE id_estado_reclamo = :id_estado_reclamo";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_estado_reclamo', $id_estado_reclamo, PDO::PARAM_INT);
        $stmt->bindParam(':activo', $activo, PDO::PARAM_BOOL);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlDeleteEstadoReclamo($id_estado_reclamo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "DELETE FROM estado_reclamo WHERE id_estado_reclamo = :id_estado_reclamo";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_estado_reclamo', $id_estado_reclamo, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }
}
