<?php

require_once 'conexion.php';

class EstadoOrden
{
    public static function mdlGetEstadoOrden($activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM estado_orden WHERE activo = :activo";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":activo", $activo, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlAddEstadoOrden($nombre, $descripcion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO estado_orden (nombre, descripcion) VALUES (:nombre, :descripcion)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":nombre", $nombre);
        $stmt->bindParam(":descripcion", $descripcion);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateEstadoOrden($id_estado_orden, $nombre, $descripcion, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE estado_orden SET nombre = :nombre, descripcion = :descripcion, activo = :activo WHERE id_estado_orden = :id_estado_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":nombre", $nombre);
        $stmt->bindParam(":descripcion", $descripcion);
        $stmt->bindParam(":activo", $activo, PDO::PARAM_INT);
        $stmt->bindParam(":id_estado_orden", $id_estado_orden, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlDeleteEstadoOrden($id_estado_orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM estado_orden WHERE id_estado_orden = :id_estado_orden";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_estado_orden", $id_estado_orden);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateEstadoOrdenActivo($id_estado_orden, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        
        $sql = "UPDATE estado_orden SET activo = :activo WHERE id_estado_orden = :id_estado_orden";
        
        $stmt = $db->prepare($sql);
        
        $stmt->bindParam(':activo', $activo, PDO::PARAM_INT);
        $stmt->bindParam(':id_estado_orden', $id_estado_orden, PDO::PARAM_INT);
        
        $stmt->execute();
        
        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }
}