<?php

require_once 'conexion.php';

class CitaSoporteTecnico
{
    public static function mdlAddCitaSoporteTecnico($id_usuario, $id_tipo_soporte_tecnico, $fecha_hora, $numero_ticket, $id_producto_orden, $id_marca, $modelo_producto, $numero_serie, $observaciones)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "INSERT INTO cita_soporte_tecnico (id_usuario, id_tipo_soporte_tecnico, fecha_hora, numero_ticket, id_producto_orden, id_marca, modelo_producto, numero_serie, observaciones) 
                VALUES (:id_usuario, :id_tipo_soporte_tecnico, :fecha_hora, :numero_ticket, :id_producto_orden, :id_marca, :modelo_producto, :numero_serie, :observaciones)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_usuario', $id_usuario);
        $stmt->bindParam(':id_tipo_soporte_tecnico', $id_tipo_soporte_tecnico);
        $stmt->bindParam(':fecha_hora', $fecha_hora);
        $stmt->bindParam(':numero_ticket', $numero_ticket);
        $stmt->bindParam(':id_producto_orden', $id_producto_orden);
        $stmt->bindParam(':id_marca', $id_marca);
        $stmt->bindParam(':modelo_producto', $modelo_producto);
        $stmt->bindParam(':numero_serie', $numero_serie);
        $stmt->bindParam(':observaciones', $observaciones);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;

        return $response;
    }

    public static function mdlGetCitaSoporteTecnico($id_cita_soporte_tecnico)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT cita_soporte_tecnico.*, tipo_soporte_tecnico.id_tipo_soporte_tecnico, tipo_soporte_tecnico.nombre AS tipo_soporte_tecnico, estado_cita.id_estado_cita, estado_cita.nombre AS estado_cita
                FROM cita_soporte_tecnico
                INNER JOIN tipo_soporte_tecnico ON cita_soporte_tecnico.id_tipo_soporte_tecnico = tipo_soporte_tecnico.id_tipo_soporte_tecnico
                INNER JOIN estado_cita ON cita_soporte_tecnico.id_estado_cita = estado_cita.id_estado_cita
                WHERE cita_soporte_tecnico.id_cita_soporte_tecnico = :id_cita_soporte_tecnico";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_cita_soporte_tecnico', $id_cita_soporte_tecnico, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetCitasSoporteTecnico($activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT cita_soporte_tecnico.*, tipo_soporte_tecnico.id_tipo_soporte_tecnico, tipo_soporte_tecnico.nombre AS tipo_soporte_tecnico, estado_cita.id_estado_cita, estado_cita.nombre AS estado_cita
                FROM cita_soporte_tecnico
                INNER JOIN tipo_soporte_tecnico ON cita_soporte_tecnico.id_tipo_soporte_tecnico = tipo_soporte_tecnico.id_tipo_soporte_tecnico
                INNER JOIN estado_cita ON cita_soporte_tecnico.id_estado_cita = estado_cita.id_estado_cita
                WHERE cita_soporte_tecnico.activo = :activo";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':activo', $activo, PDO::PARAM_BOOL);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }
    // ACTUALIZAR
    public static function mdlUpdateCitaSoporteTecnico($id_cita_soporte_tecnico, $id_usuario, $id_tipo_soporte_tecnico, $fecha_hora, $id_producto_orden, $id_marca, $modelo_producto, $numero_serie, $observaciones)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE cita_soporte_tecnico SET
                id_usuario = :id_usuario,
                id_tipo_soporte_tecnico = :id_tipo_soporte_tecnico,
                fecha_hora = :fecha_hora,
                id_producto_orden = :id_producto_orden,
                id_marca = :id_marca,
                modelo_producto = :modelo_producto,
                numero_serie = :numero_serie,
                observaciones = :observaciones
                WHERE id_cita_soporte_tecnico = :id_cita_soporte_tecnico";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_cita_soporte_tecnico', $id_cita_soporte_tecnico, PDO::PARAM_INT);
        $stmt->bindParam(':id_usuario', $id_usuario, PDO::PARAM_INT);
        $stmt->bindParam(':id_tipo_soporte_tecnico', $id_tipo_soporte_tecnico, PDO::PARAM_INT);
        $stmt->bindParam(':fecha_hora', $fecha_hora, PDO::PARAM_STR);
        $stmt->bindParam(':id_producto_orden', $id_producto_orden, PDO::PARAM_INT);
        $stmt->bindParam(':id_marca', $id_marca, PDO::PARAM_INT);
        $stmt->bindParam(':modelo_producto', $modelo_producto, PDO::PARAM_STR);
        $stmt->bindParam(':numero_serie', $numero_serie, PDO::PARAM_STR);
        $stmt->bindParam(':observaciones', $observaciones, PDO::PARAM_STR);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateActivoCitaSoporteTecnico($id_cita_soporte_tecnico, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE cita_soporte_tecnico SET activo = :activo WHERE id_cita_soporte_tecnico = :id_cita_soporte_tecnico";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_cita_soporte_tecnico', $id_cita_soporte_tecnico, PDO::PARAM_INT);
        $stmt->bindParam(':activo', $activo, PDO::PARAM_BOOL);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateTipoSoporteTecnicoCitaSoporteTecnico($id_cita_soporte_tecnico, $id_tipo_soporte_tecnico)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE cita_soporte_tecnico SET id_tipo_soporte_tecnico = :id_tipo_soporte_tecnico WHERE id_cita_soporte_tecnico = :id_cita_soporte_tecnico";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_cita_soporte_tecnico', $id_cita_soporte_tecnico, PDO::PARAM_INT);
        $stmt->bindParam(':id_tipo_soporte_tecnico', $id_tipo_soporte_tecnico, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateEstadoCita($id_cita_soporte_tecnico, $id_estado_cita)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "UPDATE cita_soporte_tecnico SET id_estado_cita = :id_estado_cita WHERE id_cita_soporte_tecnico = :id_cita_soporte_tecnico";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_cita_soporte_tecnico', $id_cita_soporte_tecnico, PDO::PARAM_INT);
        $stmt->bindParam(':id_estado_cita', $id_estado_cita, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }
    // ACTUALIZAR
    public static function mdlDeleteCitaSoporteTecnico($id_cita_soporte_tecnico)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "DELETE FROM cita_soporte_tecnico WHERE id_cita_soporte_tecnico = :id_cita_soporte_tecnico";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_cita_soporte_tecnico', $id_cita_soporte_tecnico, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlGetCitaSoporteTecnicoByIdUsuario($id_usuario)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT cita_soporte_tecnico.*, tipo_soporte_tecnico.id_tipo_soporte_tecnico, tipo_soporte_tecnico.nombre AS tipo_soporte_tecnico, estado_cita.id_estado_cita, estado_cita.nombre AS estado_cita
                FROM cita_soporte_tecnico
                INNER JOIN tipo_soporte_tecnico ON cita_soporte_tecnico.id_tipo_soporte_tecnico = tipo_soporte_tecnico.id_tipo_soporte_tecnico
                INNER JOIN estado_cita ON cita_soporte_tecnico.id_estado_cita = estado_cita.id_estado_cita
                WHERE cita_soporte_tecnico.id_usuario = :id_usuario";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_usuario', $id_usuario, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlVerifyNumeroTicket($numero_ticket)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM cita_soporte_tecnico WHERE numero_ticket = :numero_ticket";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":numero_ticket", $numero_ticket, PDO::PARAM_STR);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlGetHorariosCitaSoporteTecnicoByDia($fecha)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT fecha_hora FROM cita_soporte_tecnico WHERE DATE(fecha_hora) = :fecha";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':fecha', $fecha);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlSearchLimit($filtros, $terminoBusqueda, $orden, $offset, $limit)
    {
        $conn = new Conexion();
        $db = $conn->get_connection();

        $sqlFiltro = '';
        $sqlBusqueda = '';
        $parametrosLike = array();
        $sqlOrden = '';

        if ($filtros != NULL) {
            $numFiltros = (empty($filtros)) ? 0 : count($filtros);
            $i = 1;
            foreach ($filtros as $key => $filtro) {

                $campo = $filtro['campo'];

                if ($campo == "estado") {
                    $sqlFiltro .= "cita_soporte_tecnico.activo = " . $filtro['data']['activo'];
                }

                if ($campo == "estado_cita") {
                    $sqlFiltro .= "cita_soporte_tecnico.id_estado_cita = " . $filtro['data']['id_estado_cita'];
                }

                if ($campo == "tipo_soporte_tecnico") {
                    $sqlFiltro .= "cita_soporte_tecnico.id_tipo_soporte_tecnico = " . $filtro['data']['id_tipo_soporte_tecnico'];
                }

                if ($campo == "fecha_alta") {
                    $tipoBusqueda = $filtro['data']['tipoBusqueda'];
                    switch ($tipoBusqueda) {
                        case '1':
                            $sqlFiltro .= "DATE(cita_soporte_tecnico.fecha_alta) = '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '2':
                            $sqlFiltro .= "(cita_soporte_tecnico.fecha_alta >= '" . $filtro['data']['fecha_inicial'] . "' AND cita_soporte_tecnico.fecha_alta <= '" . $filtro['data']['fecha_final'] . "')";
                            break;
                        case '3':
                            $sqlFiltro .= "cita_soporte_tecnico.fecha_alta > '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '4':
                            $sqlFiltro .= "cita_soporte_tecnico.fecha_alta >= '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '5':
                            $sqlFiltro .= "cita_soporte_tecnico.fecha_alta < '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '6':
                            $sqlFiltro .= "cita_soporte_tecnico.fecha_alta <= '" . $filtro['data']['fecha'] . "'";
                            break;
                    }
                }

                if ($numFiltros > 1) {
                    if ($i == $numFiltros) {
                        $sqlFiltro .= "";
                    } else {
                        $sqlFiltro .= " AND ";
                    }
                }

                $i++;
            }
        }

        if ($terminoBusqueda != NULL) {
            $sqlBusqueda .= "( 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) LIKE ? OR 
                CONCAT(usuario.apellido_paterno,  ' ', usuario.apellido_materno, ' ', usuario.nombre) LIKE ? OR 
                CONCAT(usuario.apellido_materno,  ' ', usuario.apellido_paterno, ' ', usuario.nombre) LIKE ? OR 
                CONCAT(usuario.apellido_materno,  ' ', usuario.nombre, ' ', usuario.apellido_paterno) LIKE ? OR 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_materno, ' ', usuario.apellido_paterno) LIKE ? OR 
                CONCAT(usuario.apellido_paterno,  ' ', usuario.nombre, ' ', usuario.apellido_materno) LIKE ? OR 
                usuario.correo LIKE ? OR 
                usuario.celular LIKE ? OR
                producto.nombre LIKE ? OR
                producto.sku LIKE ? OR
                cita_soporte_tecnico.numero_ticket LIKE ? OR 
                cita_soporte_tecnico.numero_serie LIKE ? )";
            array_push(
                $parametrosLike,
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%",
                "%$terminoBusqueda%"
            );
        }

        if ($orden != NULL) {
            // AQUI VA EL QUERY PARA EL TERMINO DE LA ORDEN
            if ($orden['campo'] == 'nombre')
                $sqlOrden .= ' ORDER BY usuario.nombre ' . $orden['orden'];
            if ($orden['campo'] == 'fecha_alta')
                $sqlOrden .= ' ORDER BY cita_soporte_tecnico.fecha_alta ' . $orden['orden'];
            if ($orden['campo'] == 'fecha_hora')
                $sqlOrden .= ' ORDER BY cita_soporte_tecnico.fecha_hora ' . $orden['orden'];
        } else {
            $sqlOrden .= ' ORDER BY cita_soporte_tecnico.id_cita_soporte_tecnico DESC';
        }

        // CREAMOS EL COMPLEMENTO WHERE DEL QUERY PARA CONCATENARLO AL QUERY GENERAL
        $sqlTotal = '';
        if ($sqlFiltro != NULL)
            $sqlTotal .= 'WHERE ' . $sqlFiltro;

        if ($sqlBusqueda != NULL) {
            if ($sqlTotal != '')
                $sqlTotal .= ' AND ' . $sqlBusqueda;
            else
                $sqlTotal .= 'WHERE ' . $sqlBusqueda;
        }

        // ////////////////////////////////////////////////////////////////////////

        $sql = "SELECT cita_soporte_tecnico.*, usuario.nombre nombre_cliente, usuario.apellido_paterno apellido_paterno_cliente, usuario.apellido_materno apellido_materno_cliente, usuario.correo as correo_cliente, usuario.celular as celular_cliente, producto.nombre as nombre_producto, producto.is_soporte_tecnico, producto.tiempo_garantia, producto_orden.fecha_alta as fecha_compra, marca.nombre_marca, tipo_soporte_tecnico.nombre AS tipo_soporte_tecnico, estado_cita.nombre AS estado_cita
        FROM cita_soporte_tecnico left join usuario on cita_soporte_tecnico.id_usuario = usuario.id_usuario
        left join tipo_soporte_tecnico on cita_soporte_tecnico.id_tipo_soporte_tecnico = tipo_soporte_tecnico.id_tipo_soporte_tecnico
        left join estado_cita on cita_soporte_tecnico.id_estado_cita = estado_cita.id_estado_cita
        left join marca on cita_soporte_tecnico.id_marca = marca.id_marca
        left join producto_orden on cita_soporte_tecnico.id_producto_orden = producto_orden.id_producto_orden
        left join producto on producto_orden.id_producto = producto.id_producto
                 " . $sqlTotal . " " . $sqlOrden . " LIMIT " . $offset . ", " . $limit;
        // echo $sql;
        $stmt = $db->prepare($sql);
        $stmt->execute($parametrosLike);
        return ($stmt->rowCount() >= 1) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;
    }

    public static function mdlSearchTotal($filtros, $termino_busqueda)
    {

        $conn = new Conexion();
        $db = $conn->get_connection();

        $sqlFiltro = '';
        $sqlBusqueda = '';
        $parametrosLike = array();

        if ($filtros != NULL) {
            $numFiltros = (empty($filtros)) ? 0 : count($filtros);
            $i = 1;
            foreach ($filtros as $key => $filtro) {

                $campo = $filtro['campo'];

                if ($campo == "estado") {
                    $sqlFiltro .= "cita_soporte_tecnico.activo = " . $filtro['data']['activo'];
                }

                if ($campo == "estado_cita") {
                    $sqlFiltro .= "cita_soporte_tecnico.id_estado_cita = " . $filtro['data']['id_estado_cita'];
                }

                if ($campo == "tipo_soporte_tecnico") {
                    $sqlFiltro .= "cita_soporte_tecnico.id_tipo_soporte_tecnico = " . $filtro['data']['id_tipo_soporte_tecnico'];
                }

                if ($campo == "fecha_alta") {
                    $tipoBusqueda = $filtro['data']['tipoBusqueda'];
                    switch ($tipoBusqueda) {
                        case '1':
                            $sqlFiltro .= "DATE(cita_soporte_tecnico.fecha_alta) = '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '2':
                            $sqlFiltro .= "(cita_soporte_tecnico.fecha_alta >= '" . $filtro['data']['fecha_inicial'] . "' AND cita_soporte_tecnico.fecha_alta <= '" . $filtro['data']['fecha_final'] . "')";
                            break;
                        case '3':
                            $sqlFiltro .= "cita_soporte_tecnico.fecha_alta > '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '4':
                            $sqlFiltro .= "cita_soporte_tecnico.fecha_alta >= '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '5':
                            $sqlFiltro .= "cita_soporte_tecnico.fecha_alta < '" . $filtro['data']['fecha'] . "'";
                            break;
                        case '6':
                            $sqlFiltro .= "cita_soporte_tecnico.fecha_alta <= '" . $filtro['data']['fecha'] . "'";
                            break;
                    }
                }

                if ($numFiltros > 1) {
                    if ($i == $numFiltros) {
                        $sqlFiltro .= "";
                    } else {
                        $sqlFiltro .= " AND ";
                    }
                }

                $i++;
            }
        }

        if ($termino_busqueda != NULL) {
            $sqlBusqueda .= "( 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_paterno, ' ', usuario.apellido_materno) LIKE ? OR 
                CONCAT(usuario.apellido_paterno,  ' ', usuario.apellido_materno, ' ', usuario.nombre) LIKE ? OR 
                CONCAT(usuario.apellido_materno,  ' ', usuario.apellido_paterno, ' ', usuario.nombre) LIKE ? OR 
                CONCAT(usuario.apellido_materno,  ' ', usuario.nombre, ' ', usuario.apellido_paterno) LIKE ? OR 
                CONCAT(usuario.nombre,  ' ', usuario.apellido_materno, ' ', usuario.apellido_paterno) LIKE ? OR 
                CONCAT(usuario.apellido_paterno,  ' ', usuario.nombre, ' ', usuario.apellido_materno) LIKE ? OR 
                usuario.correo LIKE ? OR 
                usuario.celular LIKE ? OR
                producto.nombre LIKE ? OR
                producto.sku LIKE ? OR
                cita_soporte_tecnico.numero_ticket LIKE ? OR 
                cita_soporte_tecnico.numero_serie LIKE ? )";
            array_push(
                $parametrosLike,
                "$termino_busqueda%",
                "$termino_busqueda%",
                "$termino_busqueda%",
                "$termino_busqueda%",
                "$termino_busqueda%",
                "$termino_busqueda%",
                "%$termino_busqueda%",
                "%$termino_busqueda%",
                "%$termino_busqueda%",
                "%$termino_busqueda%",
                "%$termino_busqueda%",
                "%$termino_busqueda%"
            );
        }

        // CREAMOS EL COMPLEMENTO WHERE DEL QUERY PARA CONCATENARLO AL QUERY GENERAL
        $sqlTotal = '';
        if ($sqlFiltro != NULL)
            $sqlTotal .= 'WHERE ' . $sqlFiltro;

        if ($sqlBusqueda != NULL) {
            if ($sqlTotal != '')
                $sqlTotal .= ' AND ' . $sqlBusqueda;
            else
                $sqlTotal .= 'WHERE ' . $sqlBusqueda;
        }

        // ////////////////////////////////////////////////////////////////////////

        $sql = "SELECT COUNT(*) as total 
        FROM cita_soporte_tecnico left join usuario on cita_soporte_tecnico.id_usuario = usuario.id_usuario
        left join tipo_soporte_tecnico on cita_soporte_tecnico.id_tipo_soporte_tecnico = tipo_soporte_tecnico.id_tipo_soporte_tecnico
        left join estado_cita on cita_soporte_tecnico.id_estado_cita = estado_cita.id_estado_cita
        left join marca on cita_soporte_tecnico.id_marca = marca.id_marca
        left join producto_orden on cita_soporte_tecnico.id_producto_orden = producto_orden.id_producto_orden
        left join producto on producto_orden.id_producto = producto.id_producto
                 " . $sqlTotal;
        // echo $sql;
        $stmt = $db->prepare($sql);
        $stmt->execute($parametrosLike);
        return ($stmt->rowCount() >= 1) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;
    }

    public static function mdlGetTotalCitasEntreFechas($fecha_inicial, $fecha_final)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        $sql = "SELECT COUNT(*) as total FROM cita_soporte_tecnico WHERE DATE(fecha_alta) BETWEEN :fecha_inicial AND :fecha_final";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':fecha_inicial', $fecha_inicial);
        $stmt->bindParam(':fecha_final', $fecha_final);
        $stmt->execute();
        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;
        $db = null;
        return $response;
    }
}
