<?php

require_once 'conexion.php';

class CercaniaAlmacenOdooCP
{
    public static function mdlGetCercaniaAlmacenOdooCP()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        
        $sql = "SELECT * FROM cercania_almacen_odoo_cp";
        
        $stmt = $db->prepare($sql);
        
        $stmt->execute();
        
        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;
        
        $db = null;
        
        return $response;
    }

    public static function mdlGetUbicacionAlmacenCP($id_odoo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        
        $sql = "SELECT almacenes_odoo.cp 
                FROM cercania_almacen_odoo_cp INNER JOIN almacenes_odoo ON cercania_almacen_odoo_cp.id_almacen_odoo = almacenes_odoo.id_almacen_odoo
                WHERE almacenes_odoo.id_odoo = :id_odoo AND cercania_almacen_odoo_cp.ubicacion_almacen = 1";
        
        $stmt = $db->prepare($sql);
        
        $stmt->bindParam(":id_odoo", $id_odoo);
        
        $stmt->execute();
        
        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;
        
        $db = null;
        
        return $response;
    }
    public static function mdlAddCercaniaAlmacenOdooCP($id_almacen_odoo, $cp)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        
        $sql = "INSERT INTO cercania_almacen_odoo_cp (id_almacen_odoo, cp) VALUES (:id_almacen_odoo, :cp)";
        
        $stmt = $db->prepare($sql);
        
        $stmt->bindParam(":id_almacen_odoo", $id_almacen_odoo);
        $stmt->bindParam(":cp", $cp);
        
        $stmt->execute();
        
        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;
        
        $db = null;
        
        return $response;
    }

    public static function mdlUpdateCercaniaAlmacenOdooCP($id_cercania_almacen_odoo_cp, $id_almacen_odoo, $cp)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        
        $sql = "UPDATE cercania_almacen_odoo_cp SET id_almacen_odoo = :id_almacen_odoo, cp = :cp WHERE id_cercania_almacen_odoo_cp = :id_cercania_almacen_odoo_cp";
        
        $stmt = $db->prepare($sql);
        
        $stmt->bindParam(":id_almacen_odoo", $id_almacen_odoo);
        $stmt->bindParam(":cp", $cp);
        $stmt->bindParam(":id_cercania_almacen_odoo_cp", $id_cercania_almacen_odoo_cp);
        
        $stmt->execute();
        
        $response = ($stmt->rowCount() > 0) ? true : false;
        
        $db = null;
        
        return $response;
    }

    public static function mdlDeleteCercaniaAlmacenOdooCP($id_cercania_almacen_odoo_cp)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        
        $sql = "DELETE FROM cercania_almacen_odoo_cp WHERE id_cercania_almacen_odoo_cp = :id_cercania_almacen_odoo_cp";
        
        $stmt = $db->prepare($sql);
        
        $stmt->bindParam(":id_cercania_almacen_odoo_cp", $id_cercania_almacen_odoo_cp);
        
        $stmt->execute();
        
        $response = ($stmt->rowCount() > 0) ? true : false;
        
        $db = null;
        
        return $response;
    }

    public static function mdlValidateUbicacionAlmacenCP($id_almacen_odoo, $cp)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM cercania_almacen_odoo_cp 
                WHERE cp = :cp 
                AND id_almacen_odoo = :id_almacen_odoo
                AND activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_almacen_odoo", $id_almacen_odoo);
        $stmt->bindParam(":cp", $cp);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }
}

// TABLE `cercania_almacen_odoo_cp` (
//     `id_cercania_almacen_odoo_cp` int NOT NULL,
//     `id_almacen_odoo` int NOT NULL,
//     `cp` varchar(10) NOT NULL,
//     `fecha_alta` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
//     `activo` tinyint(1) NOT NULL DEFAULT '1'
//   )