<?php

require_once 'conexion.php';

class CercaniaAlmacenOdoo
{
    public static function mdlGetCercaniaAlmacenOdoo()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM cercania_almacen_odoo";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlAddCercaniaAlmacenOdoo($id_estado_odoo, $id_almacen_odoo, $orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO cercania_almacen_odoo (id_estado_odoo, id_almacen_odoo, orden) VALUES (:id_estado_odoo, :id_almacen_odoo, :orden)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_estado_odoo", $id_estado_odoo);
        $stmt->bindParam(":id_almacen_odoo", $id_almacen_odoo);
        $stmt->bindParam(":orden", $orden);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;
        
        return $response;
    }

    public static function mdlUpdateCercaniaAlmacenOdoo($id_cercania_almacen_odoo, $id_estado_odoo, $id_almacen_odoo, $orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE cercania_almacen_odoo SET id_estado_odoo = :id_estado_odoo, id_almacen_odoo = :id_almacen_odoo, orden = :orden WHERE id_cercania_almacen_odoo = :id_cercania_almacen_odoo";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_estado_odoo", $id_estado_odoo);
        $stmt->bindParam(":id_almacen_odoo", $id_almacen_odoo);
        $stmt->bindParam(":orden", $orden, PDO::PARAM_INT);
        $stmt->bindParam(":id_cercania_almacen_odoo", $id_cercania_almacen_odoo, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlDeleteCercaniaAlmacenOdoo($id_cercania_almacen_odoo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM cercania_almacen_odoo WHERE id_cercania_almacen_odoo = :id_cercania_almacen_odoo";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_cercania_almacen_odoo", $id_cercania_almacen_odoo);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;
        
        return $response;
    }

    public static function mdlGetCercaniaAlmacenOdooByEstado($estado)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        //Este query funcionaba sin tener que poner que cercania_almacen_odoo.orden > 0
        $sql = "SELECT cercania_almacen_odoo.*, almacenes_odoo.id_odoo,almacenes_odoo.nombre_almacen, almacenes_odoo.codigo_almacen
                FROM cercania_almacen_odoo 
                INNER JOIN estados_odoo ON cercania_almacen_odoo.id_estado_odoo = estados_odoo.id_estado_odoo
                INNER JOIN almacenes_odoo ON cercania_almacen_odoo.id_almacen_odoo = almacenes_odoo.id_almacen_odoo
                WHERE estados_odoo.nombre = :estado AND cercania_almacen_odoo.orden > 0 ORDER BY cercania_almacen_odoo.orden ASC";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":estado", $estado);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }
}