<?php

require_once 'conexion.php';

class Catalogo
{

    public static function mdlGetLastCatalogoOrder()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM catalogo ORDER BY orden DESC LIMIT 1;";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        return ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;
    }

    public static function mdlUpdateCatalogoPDF($id_catalogo, $link_pdf)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE catalogo SET link_pdf = :link_pdf WHERE id_catalogo = :id_catalogo";

        // $db->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING );
        // $db->setAttribute( PDO::ATTR_EMULATE_PREPARES, false );

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_catalogo', $id_catalogo);
        $stmt->bindParam(':link_pdf', $link_pdf);

        $stmt->execute();

        return ($stmt->rowCount() > 0) ? true : false;
    }

    public static function mdlUpdateCatalogoImagen($id_catalogo, $url_imagen)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE catalogo SET imagen_portada = :url_imagen WHERE id_catalogo = :id_catalogo";

        // $db->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING );
        // $db->setAttribute( PDO::ATTR_EMULATE_PREPARES, false );

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_catalogo', $id_catalogo);
        $stmt->bindParam(':url_imagen', $url_imagen);

        $stmt->execute();

        return ($stmt->rowCount() > 0) ? true : false;
    }

    public static function mdlUpdateOrdenCatalogo($id_catalogo, $orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        
        $sql = "UPDATE catalogo SET orden = :orden WHERE id_catalogo = :id_catalogo";
        
        $stmt = $db->prepare($sql);
        
        $stmt->bindParam(':orden', $orden, PDO::PARAM_INT);
        $stmt->bindParam(':id_catalogo', $id_catalogo, PDO::PARAM_INT);
        
        $stmt->execute();

        $respuesta = $stmt->rowCount() > 0 ? true : false;
        $db = null;
        return $respuesta;
    }

    public static function mdlIsCatalogoOrderExist($id_catalogo, $orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        
        $sql = "SELECT * FROM catalogo WHERE id_catalogo = :id_catalogo and orden = :orden";
        
        $stmt = $db->prepare($sql);
        
        $stmt->bindParam(':orden', $orden, PDO::PARAM_INT);
        $stmt->bindParam(':id_catalogo', $id_catalogo, PDO::PARAM_INT);
        
        $stmt->execute();

        $respuesta = $stmt->rowCount() > 0 ? true : false;
        $db = null;
        return $respuesta;
    }

    public static function mdlGetAllCatalogos()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM catalogo ORDER BY orden ASC";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        return ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;
    }
    
    public static function mdlGetCatalogos()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM catalogo WHERE activo = 1 ORDER BY fecha_alta DESC";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlGetCatalogoById($id_catalogo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM catalogo WHERE id_catalogo = :id_catalogo AND activo = 1";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_catalogo", $id_catalogo, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;

        $db = null;

        return $response;
    }

    public static function mdlAddCatalogo($nombre, $descripcion, $imagen_portada, $link_pdf, $orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO catalogo (nombre, descripcion, imagen_portada, link_pdf, orden) VALUES (:nombre, :descripcion, :imagen_portada, :link_pdf, :orden)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":nombre", $nombre);
        $stmt->bindParam(":descripcion", $descripcion);
        $stmt->bindParam(":imagen_portada", $imagen_portada);
        $stmt->bindParam(":link_pdf", $link_pdf);
        $stmt->bindParam(":orden", $orden);

        $stmt->execute();

        $response =  ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateCatalogo($id_catalogo, $nombre, $descripcion)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE catalogo SET nombre = :nombre, descripcion = :descripcion WHERE id_catalogo = :id_catalogo";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":nombre", $nombre);
        $stmt->bindParam(":descripcion", $descripcion);
        $stmt->bindParam(":id_catalogo", $id_catalogo, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlDeleteCatalogo($id_catalogo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM catalogo WHERE id_catalogo = :id_catalogo";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_catalogo", $id_catalogo);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateActivoCatalogo($id_catalogo, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE catalogo SET activo = :activo WHERE id_catalogo = :id_catalogo";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":activo", $activo, PDO::PARAM_INT);
        $stmt->bindParam(":id_catalogo", $id_catalogo, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }
}
