<?php

require_once 'conexion.php';

class Banner
{

    public static function mdlUpdateBannerImagen($id_banner, $url_imagen)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE banner SET url_imagen = :url_imagen WHERE id_banner = :id_banner";

        // $db->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING );
        // $db->setAttribute( PDO::ATTR_EMULATE_PREPARES, false );

        $stmt = $db->prepare($sql);

        $stmt->bindParam(':id_banner', $id_banner);
        $stmt->bindParam(':url_imagen', $url_imagen);

        $stmt->execute();

        return ($stmt->rowCount() > 0) ? true : false;
    }

    public static function mdlGetLastBannerOrder()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM banner ORDER BY orden DESC LIMIT 1;";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        return ($stmt->rowCount() > 0) ? $stmt->fetch(PDO::FETCH_ASSOC) : false;
    }

    public static function mdlGetAllBanners()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM banner ORDER BY orden ASC";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        return ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;
    }
    
    public static function mdlGetBanners()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "SELECT * FROM banner WHERE activo = 1 ORDER BY orden ASC";

        $stmt = $db->prepare($sql);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $stmt->fetchAll(PDO::FETCH_ASSOC) : false;

        $db = null;
        
        return $response;
    }

    public static function mdlAddBanner($titulo, $descripcion, $url_imagen, $link, $orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "INSERT INTO banner (titulo, descripcion, url_imagen, link, orden) VALUES (:titulo, :descripcion, :url_imagen, :link, :orden)";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":titulo", $titulo);
        $stmt->bindParam(":descripcion", $descripcion);
        $stmt->bindParam(":url_imagen", $url_imagen);
        $stmt->bindParam(":link", $link);
        $stmt->bindParam(":orden", $orden);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? $db->lastInsertId() : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateBanner($id_banner, $titulo, $descripcion, $link)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "UPDATE banner SET titulo = :titulo, descripcion = :descripcion, link = :link WHERE id_banner = :id_banner";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":titulo", $titulo);
        $stmt->bindParam(":descripcion", $descripcion);
        $stmt->bindParam(":link", $link);
        $stmt->bindParam(":id_banner", $id_banner, PDO::PARAM_INT);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlDeleteBanner($id_banner)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();

        $sql = "DELETE FROM banner WHERE id_banner = :id_banner";

        $stmt = $db->prepare($sql);

        $stmt->bindParam(":id_banner", $id_banner);

        $stmt->execute();

        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateEstadoBanner($id_banner, $activo)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        
        $sql = "UPDATE banner SET activo = :activo WHERE id_banner = :id_banner";
        
        $stmt = $db->prepare($sql);
        
        $stmt->bindParam(':activo', $activo, PDO::PARAM_INT);
        $stmt->bindParam(':id_banner', $id_banner, PDO::PARAM_INT);
        
        $stmt->execute();
        
        $response = ($stmt->rowCount() > 0) ? true : false;

        $db = null;

        return $response;
    }

    public static function mdlUpdateOrdenBanner($id_banner, $orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        
        $sql = "UPDATE banner SET orden = :orden WHERE id_banner = :id_banner";
        
        $stmt = $db->prepare($sql);
        
        $stmt->bindParam(':orden', $orden, PDO::PARAM_INT);
        $stmt->bindParam(':id_banner', $id_banner, PDO::PARAM_INT);
        
        $stmt->execute();

        $respuesta = $stmt->rowCount() > 0 ? true : false;
        $db = null;
        return $respuesta;
    }

    public static function mdlIsBannerOrderExist($id_banner, $orden)
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        
        $sql = "SELECT * FROM banner WHERE id_banner = :id_banner and orden = :orden";
        
        $stmt = $db->prepare($sql);
        
        $stmt->bindParam(':orden', $orden, PDO::PARAM_INT);
        $stmt->bindParam(':id_banner', $id_banner, PDO::PARAM_INT);
        
        $stmt->execute();

        $respuesta = $stmt->rowCount() > 0 ? true : false;
        $db = null;
        return $respuesta;
    }

    public static function mdlGetTotalBanners()
    {
        $conexion = new Conexion();
        $db = $conexion->get_connection();
        
        $sql = "SELECT COUNT(*) as total FROM banner";
        
        $stmt = $db->prepare($sql);
        
        $stmt->execute();
        
        $respuesta = $stmt->fetch(PDO::FETCH_ASSOC);
        $db = null;
        return $respuesta;
    }
}
