<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/usuario.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/odoo_cliente.php';

$response = array();

if(
    !isset($_POST['id_usuario']) || 
    !isset($_POST['rfc'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

$rfc = $_POST['rfc'];

if (!$id_usuario || !$rfc) { 
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario_odoo = intval(Usuario::mdlGetUsuarioIdOdoo($id_usuario));

$rfcPattern = '/^(?:[A-Za-z]{4}\d{6}[A-Za-z\d]{3}|[A-Za-z]{3}\d{6}[A-Za-z\d]{3})$/';

if (!preg_match($rfcPattern, $rfc)) {
    $response['response'] = 'error';
    $response['data'] = 'La estructura de RFC no es válida';
    echo json_encode($response);
    return;
}

$validar_rfc = OdooCliente::validateRFC($id_usuario_odoo, $rfc);

if (!$validar_rfc) {
    $response['response'] = 'error';
    $response['data'] = 'RFC no valido';
    echo json_encode($validar_rfc);
    return;
}

$response['response'] = 'success';
$response['data'] = 'RFC valido';
echo json_encode($validar_rfc);