<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

error_reporting(E_ALL);
error_reporting(-1);
ini_set('error_reporting', E_ALL);

require '../../modelo/usuario.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id']) ||
    !isset($_POST['id_usuario']) ||
    !isset($_POST['nombre']) ||
    !isset($_POST['apellido_paterno']) ||
    !isset($_POST['apellido_materno']) ||
    !isset($_POST['celular'])
) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id = DecodeUser::handlePostUsuario($_POST['id']);

if (!$id) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_usuario = $_POST['id_usuario'];
$nombre = $_POST['nombre'];
$apellido_paterno = $_POST['apellido_paterno'];
$apellido_materno = $_POST['apellido_materno'];
$celular = (!empty($_POST['celular'])) ? $_POST['celular'] : null;
$fecha_nacimiento = ($_POST['fecha_nacimiento'] != '') ? $_POST['fecha_nacimiento'] : null;
$id_sexo = (isset($_POST['id_sexo'])) ? $_POST['id_sexo'] : null;

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('usuario', $id_usuario));

$updated = Usuario::mdlUpdateUsuarioById($id_usuario, $nombre, $apellido_paterno, $apellido_materno, $celular, $fecha_nacimiento, $id_sexo);

if (!$updated) {
    $response['response'] = 'error';
    $response['message'] = 'No hay cambios por aplicar';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'usuario', $id_usuario, $id, $valor_anterior);

$response['response'] = 'success';
$response['message'] = 'Cliente actualizado correctamente';

echo json_encode($response);
