<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/usuario.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['activo'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$activo = $_POST['activo'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('usuario', $id_usuario));

$usuario = Usuario::mdlUpdateActivoUsuario($id_usuario, $activo);

if (!$usuario) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo actualizar el usuario.';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'usuario', $usuario, $id_usuario, $valor_anterior);
$response['response'] = 'success';
$response['data'] = $usuario;

echo json_encode($response);
return;