<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/usuario.php';
require '../../modelo/permiso_usuario.php';

$filtros = NULL;
$termino_busqueda = NULL;
$ordenar = NULL;

if (isset($_POST['filtros'])) {
    $filtros = json_decode($_POST['filtros'], true);
}

if (isset($_POST['q'])) {
    $termino_busqueda = $_POST['q'];
}

if (isset($_POST['ordenar'])) {
    $ordenar = json_decode($_POST['ordenar'], true);
}

$usuarios_administracion = Usuario::mdlBuscarByFiltrosTerminoOrden($filtros, $termino_busqueda, $ordenar);

if (!$usuarios_administracion) {
    echo json_encode([
        'response' => 'error', 
        'message' => 'No se encontraron usuarios_administracion',
    ]);
    return;
}

// Agregamos sus permisos del sistema de cada uno
foreach($usuarios_administracion as $key => $value){
    $permisos = PermisoUsuario::mdlGetPermisoByUsuario($value['id_usuario']);
    $usuarios_administracion[$key]['permisos'] = array();
    if($permisos){
        $usuarios_administracion[$key]['permisos'] = $permisos;
    }
}

http_response_code(200); // success
echo json_encode([
    'response' => 'success', 
    'message' => 'Se encontraron los usuarios',
    'data' => $usuarios_administracion
]);