<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/usuario.php';
require '../../modelo/correo.php';
require '../../modelo/environment.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (!isset($_POST['correo'])) {
    $response['response'] = 'error';
    $response['data'] = 'POST Error';
    echo json_encode($response);
    return;
}

$correo = $_POST['correo'];

$informacion_usuario = Usuario::mdlGetUsuarioByCorreo($correo);

if (!$informacion_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'No se encontró el usuario';
    echo json_encode($response);
    return;
}

$codigo = rand(100000, 999999);

$codigo_aleatorio = Usuario::mdlCodigoAleatorioRecuperarPassword($correo, $codigo);

if (!$codigo_aleatorio) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo generar el código';
    echo json_encode($response);
    return;
}

$id_usuario = Environment::encodeUser($informacion_usuario['id_usuario']);

$url = 'https://mtm.buscalab.com/confirmar-password/' . $codigo_aleatorio . '/' . $id_usuario;

$enviar_correo = Correo::mdlRecuperarPassword($correo, $url, $informacion_usuario['nombre']);

if (!$enviar_correo) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo enviar el correo';

    $codigo_aleatorio = Usuario::mdlCodigoAleatorioRecuperarPassword($correo, null);

    echo json_encode($response);
    return;
}

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('usuario', $informacion_usuario['id_usuario']));
ModeloHistory::mdlAddNewRegister('update', 'usuario', $informacion_usuario['id_usuario'], $informacion_usuario['id_usuario'], $valor_anterior);

$response['response'] = 'success';
$response['data'] = true;
echo json_encode($response);
