<?php

// error_reporting(E_ALL);
// ini_set('display_errors', 1);
// ini_set('error_reporting', E_ALL);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/usuario.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (!isset($_POST['id_usuario'])) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

if (!isset($_FILES['foto_perfil']['name'])) {
    $response['response'] = 'error';
    $response['data'] = 'No hay foto de perfil';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$foto_perfil = $_FILES['foto_perfil']['name'];

$extension = pathinfo($foto_perfil, PATHINFO_EXTENSION);
$nombreFotoPerfil = uniqid() . "-" . $id_usuario . '.' . $extension;

$url_servidor = Environment::getUrlServidor();
$fotoPerfilRuta = '../../assets/images/usuario/' . $nombreFotoPerfil;

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('usuario', $id_usuario));

if (!move_uploaded_file($_FILES['foto_perfil']['tmp_name'], $fotoPerfilRuta)) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo subir la foto de perfil';
    echo json_encode($response);
    return;
}

if (Usuario::mdlUpdateUsuarioFotoPerfil($id_usuario, 'assets/images/usuario/'.$nombreFotoPerfil)) {
    $response['response'] = 'success';
    $response['data'] = true;
    echo json_encode($response);
    return;
}