<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/usuario.php';
require '../../modelo/environment.php';
require '../usuario/decodeUsuario.php';

$response = array();
if (!isset($_POST['id_usuario'])) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if(!$id_usuario){
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$usuario = Usuario::mdlGetUsuarioById($id_usuario);

unset($usuario['password']);
unset($usuario['id_usuario']);
unset($usuario['codigo_recover_password']);
unset($usuario['date_recover_password']);
unset($usuario['fecha_alta']);
unset($usuario['id_cliente_openpay']);
unset($usuario['id_tipo_usuario']);
unset($usuario['id_usuario_odoo']);
unset($usuario['ip']);
unset($usuario['pais']);
unset($usuario['user_agent']);

if(!$usuario){
    $response['response'] = 'error';
    $response['data'] = 'Usuario no encontrado';
    echo json_encode($response);
    return;
}

if(is_null($usuario['uid_google']) && is_null($usuario['uid_facebook'])){
    $usuario['foto_perfil'] = Environment::getUrlServidor() . $usuario['foto_perfil'];
}

unset($usuario['uid_google']);
unset($usuario['uid_facebook']);

$response['response'] = 'success';
$response['data'] = $usuario;

echo json_encode($response);
