<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require '../../modelo/usuario.php';
require '../../modelo/odoo_cliente.php';
require '../../modelo/correo.php';
// Siempre que se utilice este modelo debe ser con require_once
require_once '../../modelo/odoo_auth.php';
require '../../modelo/environment.php';
require '../../modelo/history.php';
$response = array();

if (
    !isset($_POST['nombre']) ||
    !isset($_POST['correo']) ||
    !isset($_POST['celular']) ||
    !isset($_POST['foto']) ||
    !isset($_POST['uid'])
) {
    $response['response'] = 'error';
    $response['data'] = 'POST Error';
    echo json_encode($response);
    return;
}

// $ip = $_SERVER['REMOTE_ADDR'];
$ip = "192.168.1.1";

$details = json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip={$ip}"));
// $pais = $details->geoplugin_countryCode;
$pais = "MX";

// $user_agent = $_SERVER['HTTP_USER_AGENT'];
$user_agent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36";

$correo = $_POST['correo'];
$celular = (isset($_POST['celular'])) ? $_POST['celular'] : null;

$validar_usuario_existente = Usuario::mdlVerifyUsuarioExistente($correo, $celular);

if ($validar_usuario_existente) {
    $response['response'] = 'error';
    $response['data'] = 'El usuario ya existe';
    echo json_encode($response);
    return;
}

$nombre_aux = $_POST['nombre'];
$nombre_partes = explode(' ', $nombre_aux);

switch (count($nombre_partes)) {
    case 1:
        $nombre = $nombre_partes[0];
        $apellido_paterno = null;
        $apellido_materno = null;
        break;
    case 2:
        $nombre = $nombre_partes[0];
        $apellido_paterno = $nombre_partes[1];
        $apellido_materno = null;
        break;
    case 3:
        $nombre = $nombre_partes[0];
        $apellidos = array_slice($nombre_partes, -2);
        $apellido_paterno =  $apellidos[0];
        $apellido_materno = $apellidos[1];
        break;
    default:
        $nombre = $nombre_partes[0] . ' ' . $nombre_partes[1];
        $apellidos = array_slice($nombre_partes, -2);
        $apellido_paterno = $apellidos[0];
        $apellido_materno = $apellidos[1];
        break;
}

$uid_google = $_POST['uid'];
// $apellido_paterno = $_POST['apellido_paterno'];
// $apellido_materno = $_POST['apellido_materno'];
$foto_perfil = $_POST['foto'];
$password = (isset($_POST['password'])) ? password_hash($_POST['password'], PASSWORD_DEFAULT) : null;
$fecha_nacimiento = (isset($_POST['fecha_nacimiento'])) ? $_POST['fecha_nacimiento'] : null;
$id_sexo = (isset($_POST['id_sexo'])) ? $_POST['id_sexo'] : null;
$uid_google = ($uid_google) ? $uid_google : null;
$uid_facebook = (isset($_POST['uid_facebook'])) ? $_POST['uid_facebook'] : null;

$agregarUsuario = Usuario::mdlAddUsuario(
    NULL,
    $nombre,
    $apellido_paterno,
    $apellido_materno,
    $correo,
    $celular,
    $password,
    $fecha_nacimiento,
    $id_sexo,
    $pais,
    $user_agent,
    $ip,
    $uid_google,
    $uid_facebook
);

if (!$agregarUsuario) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo agregar el usuario';
    echo json_encode($response);
    return;
}

$agregarUsuarioOdoo = OdooCliente::addClient($nombre, $apellido_paterno . ' ' . $apellido_materno, $celular, $correo, intval(OdooAuth::getClientCategoryId()));

if (!$agregarUsuarioOdoo) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo agregar el usuario en Odoo';
    echo json_encode($response);
    return;
}

$actualizarUsuarioOdoo = Usuario::mdlUpdateUsuarioIdOdoo($agregarUsuario, $agregarUsuarioOdoo);

if (!$actualizarUsuarioOdoo) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo actualizar el usuario en Odoo';
    echo json_encode($response);
    return;
}

// $enviar_correo = Correo::mdlAddUsuario($correo, $nombre);

// if (!$enviar_correo) {
//     $response['response'] = 'error';
//     $response['data'] = 'No se pudo enviar el correo';

//     $codigo_aleatorio = Usuario::mdlUpdateActivoUsuario($agregarUsuario, 0);

//     echo json_encode($response);
//     return;
// }

$usuario = Usuario::mdlGetUsuarioRegistro($agregarUsuario);

if (!$usuario) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo obtener el usuario';
    echo json_encode($response);
    return;
}

$actualizar_foto = Usuario::mdlUpdateUsuarioFotoPerfil($agregarUsuario, $foto_perfil);

if (!$actualizar_foto) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo actualizar la foto de perfil';
    echo json_encode($response);
}

$usuario['id_usuario'] = Environment::encodeUser($agregarUsuario);

$usuario['foto_perfil'] = $foto_perfil;

$response['response'] = 'success';
$response['data'] = $usuario;
echo json_encode($response);
