<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/tipo_variacion.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_tipo_variacion']) ||
    !isset($_POST['id_usuario'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_tipo_variacion = $_POST['id_tipo_variacion'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('tipo_variacion', $id_tipo_variacion));

$tipo_variacion = TipoVariacion::mdlDeleteTipoVariacion($id_tipo_variacion);

if (!$tipo_variacion) {
    $response['response'] = 'error';
    $response['data'] = 'No se eliminó el tipo_variacion';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('delete', 'tipo_variacion', $id_tipo_variacion, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = $tipo_variacion;

echo json_encode($response);