<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/tipo_soporte_tecnico.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (!isset($_POST['id_tipo_soporte_tecnico'])) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_tipo_soporte_tecnico = $_POST['id_tipo_soporte_tecnico'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('tipo_soporte_tecnico', $id_tipo_soporte_tecnico));

$tipo_soporte_tecnico = TipoSoporteTecnico::mdlDeleteTipoSoporteTecnico($id_tipo_soporte_tecnico);

if (!$tipo_soporte_tecnico) {
    $response['response'] = 'error';
    $response['data'] = 'No se eliminó el tipo de soporte técnico';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('delete', 'tipo_soporte_tecnico', $id_tipo_soporte_tecnico, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = true;

echo json_encode($response);