<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require_once '../../modelo/direcciones_sepomex.php';

$csvFilePath = '../../vista/assets/sepomex/sepomex-1.csv';

$handle = fopen($csvFilePath, 'r');
if ($handle === false) {
    throw new Exception("Could not open file: $csvFilePath");
}

$successCount = 0;
$totalCount = 0;

while (($data = fgetcsv($handle, 1000, "|")) !== false) {
    $totalCount++;
    list(
        $d_codigo, $d_asenta, $d_tipo_asenta, $d_mnpio, $d_estado, $d_cp,
        $c_estado, $c_oficina, $c_cp, $c_tipo_asenta, $c_mnpio,
        $id_asenta_cpcons, $d_zona, $c_cve_ciudad
    ) = $data;

    $result = DireccionesSEPOMEX::mdlAddDireccionSEPOMEX(
        $d_codigo,
        $d_asenta,
        $d_tipo_asenta,
        $d_mnpio,
        $d_estado,
        $d_cp,
        $c_estado,
        $c_oficina,
        $c_cp,
        $c_tipo_asenta,
        $c_mnpio,
        $id_asenta_cpcons,
        $d_zona,
        $c_cve_ciudad
    );

    if ($result) {
        echo "Row inserted successfully: $d_codigo\n";
        $successCount++;
    } else {
        echo "Failed to insert row: $d_codigo\n";
    }
}

fclose($handle);

echo "Total rows inserted: $successCount\n";
echo "Total rows processed: $totalCount\n";

if ($successCount === $totalCount) {
    echo "All rows were inserted successfully.\n";
} else {
    echo "Some rows were not inserted successfully.\n";
}
?>