<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/respuesta.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
$response = array();

if (
    !isset($_POST['id']) ||
    !isset($_POST['id_pregunta']) ||
    !isset($_POST['respuesta'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id = DecodeUser::handlePostUsuario($_POST['id']);

if (!$id) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_pregunta = $_POST['id_pregunta'];
$respuesta = $_POST['respuesta'];

$respuesta = Respuesta::mdlAddRespuesta($id_pregunta, $id, $respuesta);

if (!$respuesta) {
    $response['response'] = 'error';
    $response['data'] = 'No se agregó el historial';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('add', 'respuesta', $respuesta, $id, NULL);

$response['response'] = 'success';
$response['data'] = 'Respuesta agregada';
echo json_encode($response);