<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/red_social.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['url']) ||
    !isset($_POST['id_red_social'])
) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);
if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$url = $_POST['url'];
$id_red_social = $_POST['id_red_social'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('red_social', $id_red_social));

$update = RedSocial::mdlUpdateRedSocial($id_red_social, $url);

if ($update) {
    ModeloHistory::mdlAddNewRegister('update', 'catalogo', $id_red_social, $id_usuario, $valor_anterior);
}

$response['response'] = 'success';
$response['data'] = $update;
echo json_encode($response);