<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/reclamo_devolucion.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_reclamo_devolucion']) ||
    !isset($_POST['id_orden']) ||
    !isset($_POST['id_estado_reclamo']) ||
    !isset($_POST['motivo'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_reclamo_devolucion = $_POST['id_reclamo_devolucion'];
$id_orden = $_POST['id_orden'];
$id_estado_reclamo = $_POST['id_estado_reclamo'];
$motivo = $_POST['motivo'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('reclamo_devolucion', $id_reclamo_devolucion));

$reclamo_devolucion = ReclamoDevolucion::mdlUpdateReclamoDevolucion($id_reclamo_devolucion, $id_usuario, $id_orden, $id_estado_reclamo, $motivo);

if (!$reclamo_devolucion) {
    $response['response'] = 'error';
    $response['data'] = 'No se actualizó el reclamo de devolución';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'reclamo_devolucion', $id_reclamo_devolucion, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = true;

echo json_encode($response);
